/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.apache.ignite.internal.type.DecimalNativeType;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.TemporalNativeType;
import org.apache.ignite.internal.util.HashCalculator;
import org.jetbrains.annotations.Nullable;

public class ColocationUtils {
    private ColocationUtils() {
    }

    public static void append(HashCalculator calc, @Nullable Object v, NativeType type) {
        if (v == null) {
            calc.appendNull();
            return;
        }
        switch (type.spec()) {
            case BOOLEAN: {
                calc.appendBoolean(((Boolean)v).booleanValue());
                return;
            }
            case INT8: {
                calc.appendByte(((Byte)v).byteValue());
                return;
            }
            case INT16: {
                calc.appendShort(((Short)v).shortValue());
                return;
            }
            case INT32: {
                calc.appendInt(((Integer)v).intValue());
                return;
            }
            case INT64: {
                calc.appendLong(((Long)v).longValue());
                return;
            }
            case FLOAT: {
                calc.appendFloat(((Float)v).floatValue());
                return;
            }
            case DOUBLE: {
                calc.appendDouble(((Double)v).doubleValue());
                return;
            }
            case DECIMAL: {
                calc.appendDecimal((BigDecimal)v, ((DecimalNativeType)type).scale());
                return;
            }
            case UUID: {
                calc.appendUuid((UUID)v);
                return;
            }
            case STRING: {
                calc.appendString((String)v);
                return;
            }
            case BYTE_ARRAY: {
                calc.appendBytes((byte[])v);
                return;
            }
            case DATE: {
                calc.appendDate((LocalDate)v);
                return;
            }
            case TIME: {
                calc.appendTime((LocalTime)v, ((TemporalNativeType)type).precision());
                return;
            }
            case DATETIME: {
                calc.appendDateTime((LocalDateTime)v, ((TemporalNativeType)type).precision());
                return;
            }
            case TIMESTAMP: {
                calc.appendTimestamp((Instant)v, ((TemporalNativeType)type).precision());
                return;
            }
        }
        throw new IllegalStateException("Unexpected type: " + String.valueOf(type.spec()));
    }

    public static int hash(@Nullable Object v, NativeType type) {
        if (v == null) {
            return HashCalculator.hashValue(null, (int)0, (int)0);
        }
        switch (type.spec()) {
            case BOOLEAN: 
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case UUID: 
            case STRING: 
            case BYTE_ARRAY: 
            case DATE: {
                return HashCalculator.hashValue((Object)v, (int)0, (int)0);
            }
            case DECIMAL: {
                assert (type instanceof DecimalNativeType);
                return HashCalculator.hashValue((Object)v, (int)((DecimalNativeType)type).scale(), (int)0);
            }
            case TIME: 
            case DATETIME: 
            case TIMESTAMP: {
                assert (type instanceof TemporalNativeType);
                return HashCalculator.hashValue((Object)v, (int)0, (int)((TemporalNativeType)type).precision());
            }
        }
        throw new IllegalStateException("Unexpected type: " + String.valueOf(type.spec()));
    }
}

