/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory;

import org.apache.ignite.internal.lang.IgniteStringBuilder;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.apache.ignite.internal.util.IgniteUtils;

public class FullPageId {
    public static final FullPageId NULL_PAGE = new FullPageId(-1L, -1);
    private final long pageId;
    private final int groupId;

    public FullPageId(long pageId, int groupId) {
        this.pageId = pageId;
        this.groupId = groupId;
    }

    public long pageId() {
        return this.pageId;
    }

    public long effectivePageId() {
        return PageIdUtils.effectivePageId(this.pageId);
    }

    public int groupId() {
        return this.groupId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FullPageId that = (FullPageId)o;
        return this.effectivePageId() == that.effectivePageId() && this.groupId == that.groupId;
    }

    public int hashCode() {
        return FullPageId.hashCode0(this.groupId, PageIdUtils.effectivePageId(this.pageId));
    }

    public static int hashCode(int groupId, long pageId) {
        long effectiveId = PageIdUtils.effectivePageId(pageId);
        return IgniteUtils.hash((int)FullPageId.hashCode0(groupId, effectiveId));
    }

    private static int hashCode0(int groupId, long effectivePageId) {
        return (int)(FullPageId.mix64(effectivePageId) ^ (long)FullPageId.mix32(groupId));
    }

    public static int mix32(int k) {
        k = (k ^ k >>> 16) * -2048144789;
        k = (k ^ k >>> 13) * -1028477387;
        return k ^ k >>> 16;
    }

    public static long mix64(long z) {
        z = (z ^ z >>> 32) * 5536775847593249645L;
        z = (z ^ z >>> 29) * -282946459933713943L;
        return z ^ z >>> 32;
    }

    public String toString() {
        return new IgniteStringBuilder("FullPageId [pageId=").appendHex(this.pageId).app(", effectivePageId=").appendHex(this.effectivePageId()).app(", groupId=").app(this.groupId).app(']').toString();
    }

    public int partitionId() {
        return PageIdUtils.partitionId(this.pageId);
    }

    public int pageIdx() {
        return PageIdUtils.pageIndex(this.pageId);
    }
}

