/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.versioned;

import java.io.IOException;
import org.apache.ignite.shaded.org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.shaded.org.apache.ignite.internal.util.io.IgniteUnsafeDataInput;
import org.apache.ignite.shaded.org.apache.ignite.internal.util.io.IgniteUnsafeDataOutput;
import org.apache.ignite.shaded.org.apache.ignite.internal.versioned.VersionedSerializer;
import org.apache.ignite.shaded.org.apache.ignite.lang.ErrorGroups;

public class VersionedSerialization {
    private static final int INITIAL_BUFFER_CAPACITY = 256;

    public static <T> byte[] toBytes(T object, VersionedSerializer<T> serializer) {
        byte[] byArray;
        IgniteUnsafeDataOutput out = new IgniteUnsafeDataOutput(256);
        try {
            serializer.writeExternal(object, out);
            byArray = out.array();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Cannot serialize", (Throwable)e);
            }
        }
        out.close();
        return byArray;
    }

    public static <T> T fromBytes(byte[] bytes, VersionedSerializer<T> serializer) {
        IgniteUnsafeDataInput in = new IgniteUnsafeDataInput(bytes);
        try {
            T result = serializer.readExternal(in);
            if (in.available() != 0) {
                throw new IOException(in.available() + " bytes left unread after deserializing " + String.valueOf(result));
            }
            return result;
        }
        catch (IOException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Cannot deserialize", (Throwable)e);
        }
    }
}

