/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.state;

import java.util.UUID;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.state.AbstractCompletable;
import org.apache.cassandra.repair.state.AbstractState;

public class ValidationState
extends AbstractState<State, UUID> {
    public final Phase phase = new Phase();
    public final RepairJobDesc desc;
    public final InetAddressAndPort initiator;
    public long estimatedPartitions;
    public long estimatedTotalBytes;
    public long partitionsProcessed;
    public long bytesRead;

    public ValidationState(RepairJobDesc desc, InetAddressAndPort initiator) {
        super(desc.determanisticId(), State.class);
        this.desc = desc;
        this.initiator = initiator;
    }

    public float getProgress() {
        int currentState = this.currentState;
        if (currentState == -1) {
            return 0.0f;
        }
        if (currentState == -2) {
            return 1.0f;
        }
        if (this.estimatedPartitions == 0L) {
            return 0.0f;
        }
        return Math.min(0.99f, (float)this.partitionsProcessed / (float)this.estimatedPartitions);
    }

    public final class Phase
    extends AbstractCompletable.BaseSkipPhase {
        public void start(long estimatedPartitions, long estimatedTotalBytes) {
            ValidationState.this.updateState(State.START);
            ValidationState.this.estimatedPartitions = estimatedPartitions;
            ValidationState.this.estimatedTotalBytes = estimatedTotalBytes;
        }

        public void sendingTrees() {
            ValidationState.this.updateState(State.SENDING_TREES);
        }
    }

    public static enum State {
        START,
        SENDING_TREES;

    }
}

