/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.DBDateCellRenderer;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.SQLConnection;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;

class SQLResultSetData
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private SQLConnection connection_ = null;
    private String query_ = null;
    private transient Object[][] data_ = null;
    private transient ResultSet resultSet_ = null;
    private transient Statement stmt_ = null;
    private transient boolean resourceOpen_ = false;
    private transient int numColumns_ = 0;
    private transient ResultSetMetaData resultSetMetaData_ = null;
    private static int ROW_INCREMENT_ = 100;
    private transient int numRows_ = 0;
    private transient int lastRecordRead_ = -1;
    private transient boolean allRecordsRead_ = true;
    private transient SQLWarning warnings_;
    private transient boolean error_;
    private transient ErrorEventSupport errorListeners_ = new ErrorEventSupport(this);
    private transient WorkingEventSupport workingListeners_ = new WorkingEventSupport(this);
    private boolean fireWorkingEvents_ = true;

    public void addErrorListener(ErrorListener listener) {
        this.errorListeners_.addErrorListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingListeners_.addWorkingListener(listener);
    }

    public synchronized void close() {
        if (this.resourceOpen_) {
            try {
                this.resultSet_.close();
            }
            catch (SQLException e) {
                this.errorListeners_.fireError(e);
            }
        }
        if (this.stmt_ != null) {
            try {
                this.stmt_.close();
            }
            catch (SQLException e) {
                this.errorListeners_.fireError(e);
            }
        }
        this.resourceOpen_ = false;
    }

    public void clearWarnings() {
        this.warnings_ = null;
        if (this.resultSet_ != null) {
            try {
                this.resultSet_.clearWarnings();
            }
            catch (SQLException e) {
                this.errorListeners_.fireError(e);
            }
        }
    }

    public synchronized boolean getAllRecordsProcessed() {
        return this.allRecordsRead_;
    }

    public synchronized int getColumnDisplaySize(int index) {
        if (this.resultSet_ == null) {
            throw new IndexOutOfBoundsException("index");
        }
        int result = 0;
        try {
            switch (this.resultSetMetaData_.getColumnType(index + 1)) {
                case 92: {
                    result = DBDateCellRenderer.getDisplaySize(1);
                    break;
                }
                case 91: {
                    result = DBDateCellRenderer.getDisplaySize(3);
                    break;
                }
                case 93: {
                    result = DBDateCellRenderer.getDisplaySize(2);
                    break;
                }
                default: {
                    result = this.resultSetMetaData_.getColumnDisplaySize(index + 1);
                    break;
                }
            }
        }
        catch (SQLException e) {
            this.errorListeners_.fireError(e);
        }
        return result;
    }

    public synchronized String getColumnLabel(int index) {
        if (this.resultSet_ == null) {
            throw new IndexOutOfBoundsException("index");
        }
        try {
            return this.resultSetMetaData_.getColumnLabel(index + 1);
        }
        catch (SQLException e) {
            this.errorListeners_.fireError(e);
            return "";
        }
    }

    public synchronized String getColumnName(int index) {
        if (this.resultSet_ == null) {
            throw new IndexOutOfBoundsException("index");
        }
        try {
            return this.resultSetMetaData_.getColumnName(index + 1);
        }
        catch (SQLException e) {
            this.errorListeners_.fireError(e);
            return "";
        }
    }

    public synchronized int getColumnType(int index) {
        if (this.resultSet_ == null) {
            throw new IndexOutOfBoundsException("index");
        }
        try {
            return this.resultSetMetaData_.getColumnType(index + 1);
        }
        catch (SQLException e) {
            this.errorListeners_.fireError(e);
            return 1;
        }
    }

    public SQLConnection getConnection() {
        return this.connection_;
    }

    public synchronized int getLastRecordProcessed() {
        return this.lastRecordRead_;
    }

    public synchronized int getNumberOfColumns() {
        return this.numColumns_;
    }

    public synchronized int getNumberOfRows() {
        if (!this.allRecordsRead_) {
            this.readAllRecords();
        }
        return this.numRows_;
    }

    public String getQuery() {
        return this.query_;
    }

    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        if (this.resultSet_ == null) {
            throw new IndexOutOfBoundsException("rowIndex");
        }
        if (this.lastRecordRead_ < rowIndex) {
            this.readMoreRecords(rowIndex - this.lastRecordRead_);
        }
        if (this.lastRecordRead_ < rowIndex) {
            throw new IndexOutOfBoundsException("rowIndex");
        }
        return this.data_[rowIndex][columnIndex];
    }

    public synchronized SQLWarning getWarnings() {
        SQLWarning result = null;
        if (this.resultSet_ != null) {
            SQLWarning rs_warnings = null;
            try {
                rs_warnings = this.resultSet_.getWarnings();
            }
            catch (SQLException e) {
                this.errorListeners_.fireError(e);
            }
            if (this.warnings_ != null) {
                if (rs_warnings != null) {
                    SQLWarning next;
                    SQLWarning last = this.warnings_;
                    while ((next = last.getNextWarning()) != null) {
                        last = next;
                    }
                    last.setNextWarning(rs_warnings);
                }
                result = this.warnings_;
            } else {
                result = rs_warnings;
            }
        }
        return result;
    }

    public synchronized void load() {
        Trace.log(1, "Doing data load.");
        if (this.connection_ == null || this.query_ == null) {
            Trace.log(1, "Data not set for load, exiting.");
            return;
        }
        if (this.fireWorkingEvents_) {
            this.workingListeners_.fireStartWorking();
        }
        if (this.resourceOpen_) {
            try {
                this.resultSet_.close();
            }
            catch (SQLException e) {
                this.errorListeners_.fireError(e);
            }
            this.resourceOpen_ = false;
        }
        this.resultSetMetaData_ = null;
        this.numColumns_ = 0;
        this.lastRecordRead_ = -1;
        this.allRecordsRead_ = true;
        this.data_ = null;
        this.numRows_ = 0;
        try {
            if (this.stmt_ == null) {
                Connection conn = this.connection_.getConnection();
                this.stmt_ = conn.createStatement();
                try {
                    this.warnings_ = conn.getWarnings();
                }
                catch (SQLException e) {
                    this.errorListeners_.fireError(e);
                }
            }
            this.resultSet_ = this.stmt_.executeQuery(this.query_);
            this.resourceOpen_ = true;
            try {
                SQLWarning s_warnings = this.stmt_.getWarnings();
                if (s_warnings != null) {
                    if (this.warnings_ == null) {
                        this.warnings_ = s_warnings;
                    } else {
                        SQLWarning next;
                        SQLWarning last = this.warnings_;
                        while ((next = last.getNextWarning()) != null) {
                            last = next;
                        }
                        last.setNextWarning(s_warnings);
                    }
                }
            }
            catch (SQLException e) {
                this.errorListeners_.fireError(e);
            }
            this.resultSetMetaData_ = this.resultSet_.getMetaData();
            this.numColumns_ = this.resultSetMetaData_.getColumnCount();
            if (!this.resultSet_.next()) {
                try {
                    this.resultSet_.close();
                }
                catch (SQLException e) {
                    this.errorListeners_.fireError(e);
                }
            } else {
                this.allRecordsRead_ = false;
                this.data_ = new Object[ROW_INCREMENT_][this.numColumns_];
            }
        }
        catch (SQLException e) {
            this.resultSet_ = null;
            this.resultSetMetaData_ = null;
            this.numColumns_ = 0;
            this.errorListeners_.fireError(e);
            this.error_ = true;
        }
        if (this.fireWorkingEvents_) {
            this.workingListeners_.fireStopWorking();
        }
    }

    public synchronized void readAllRecords() {
        Trace.log(1, "Reading all rows.");
        this.workingListeners_.fireStartWorking();
        this.error_ = false;
        while (!this.allRecordsRead_ && !this.error_) {
            this.fireWorkingEvents_ = false;
            this.readMoreRecords(ROW_INCREMENT_);
            this.fireWorkingEvents_ = true;
        }
        this.workingListeners_.fireStopWorking();
    }

    public synchronized void readMoreRecords(int numberToRead) {
        Trace.log(1, "Reading more rows:", numberToRead);
        if (this.fireWorkingEvents_) {
            this.workingListeners_.fireStartWorking();
        }
        this.error_ = false;
        if (!this.allRecordsRead_) {
            if (this.lastRecordRead_ + numberToRead >= this.data_.length) {
                int sizeNeeded = this.lastRecordRead_ + numberToRead + 1;
                int increment = ROW_INCREMENT_ > sizeNeeded ? ROW_INCREMENT_ : sizeNeeded;
                Object[][] newData = new Object[this.data_.length + increment][this.numColumns_];
                System.arraycopy(this.data_, 0, newData, 0, this.data_.length);
                this.data_ = newData;
            }
            Vector<SQLException> errors = null;
            for (int i = 1; i <= numberToRead; ++i) {
                for (int j = 1; j <= this.numColumns_; ++j) {
                    try {
                        this.data_[this.lastRecordRead_ + 1][j - 1] = this.resultSet_.getObject(j);
                        continue;
                    }
                    catch (SQLException e) {
                        this.data_[this.lastRecordRead_ + 1][j - 1] = null;
                        boolean dupErr = false;
                        if (errors == null) {
                            errors = new Vector<SQLException>();
                            errors.addElement(e);
                        } else {
                            for (int k = 0; k < errors.size(); ++k) {
                                SQLException e1 = (SQLException)errors.elementAt(k);
                                if (!e.getSQLState().equals(e1.getSQLState()) || e.getErrorCode() != e1.getErrorCode() || !e.getMessage().equals(e1.getMessage())) continue;
                                dupErr = true;
                                Trace.log(1, "Duplicate error getting column value, swallowing error: " + e.getSQLState() + " : " + e.getErrorCode() + " : " + e.getMessage());
                                break;
                            }
                            errors.addElement(e);
                        }
                        if (dupErr) continue;
                        this.errorListeners_.fireError(e);
                    }
                }
                ++this.lastRecordRead_;
                boolean valid = false;
                try {
                    valid = this.resultSet_.next();
                }
                catch (SQLException e) {
                    this.errorListeners_.fireError(e);
                    this.error_ = true;
                    valid = false;
                }
                if (valid) continue;
                this.allRecordsRead_ = true;
                try {
                    this.resultSet_.close();
                    this.resourceOpen_ = false;
                }
                catch (SQLException e) {
                    this.errorListeners_.fireError(e);
                }
                this.numRows_ = this.lastRecordRead_ + 1;
                break;
            }
        }
        if (this.fireWorkingEvents_) {
            this.workingListeners_.fireStopWorking();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.data_ = null;
        this.resultSet_ = null;
        this.stmt_ = null;
        this.resourceOpen_ = false;
        this.numColumns_ = 0;
        this.resultSetMetaData_ = null;
        this.numRows_ = 0;
        this.lastRecordRead_ = -1;
        this.allRecordsRead_ = true;
        this.errorListeners_ = new ErrorEventSupport(this);
        this.workingListeners_ = new WorkingEventSupport(this);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorListeners_.removeErrorListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingListeners_.removeWorkingListener(listener);
    }

    public void setConnection(SQLConnection connection) {
        if (connection != this.connection_) {
            this.connection_ = connection;
            if (this.stmt_ != null) {
                try {
                    this.stmt_.close();
                }
                catch (SQLException e) {
                    this.errorListeners_.fireError(e);
                }
            }
            this.stmt_ = null;
            this.warnings_ = null;
        }
    }

    public void setQuery(String query) {
        this.query_ = query;
    }
}

