/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Structure;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ValidationListAttributeData;

public class ValidationListAttribute {
    private AS400 as400_ = null;
    private AS400Structure attribEntry_ = null;
    private ValidationListAttributeData data_ = null;
    private String identifier_ = null;
    private int maxValueLength_ = 1;
    private int location_ = 0;
    private int type_ = 0;

    public ValidationListAttribute() {
    }

    public ValidationListAttribute(AS400 as400) {
        this();
        this.setAS400(as400);
    }

    public AS400 getAS400() {
        return this.as400_;
    }

    private AS400Structure getAttribEntryStruct() {
        if (this.attribEntry_ == null) {
            this.attribEntry_ = new AS400Structure(new AS400DataType[]{new AS400Bin4(), new AS400Bin4(), new AS400Bin4(), new AS400Bin4(), new AS400Bin4()});
        }
        return this.attribEntry_;
    }

    public int getByteLength() {
        int mod;
        ValidationListAttributeData data = this.getData();
        int total = data == null ? 24 : 28;
        total += this.getIdentifier().length();
        if (data != null) {
            total += data.getByteLength();
        }
        if ((mod = total % 4) > 0) {
            total += 4 - mod;
        }
        return total;
    }

    public ValidationListAttributeData getData() {
        return this.data_;
    }

    public String getIdentifier() {
        return this.identifier_;
    }

    public int getLocation() {
        return this.location_;
    }

    public int getMaximumValueLength() {
        return this.maxValueLength_;
    }

    public int getType() {
        return this.type_;
    }

    public void setAS400(AS400 as400) {
        this.as400_ = as400;
    }

    public void setData(ValidationListAttributeData data) {
        this.data_ = data;
    }

    public void setIdentifier(String s) {
        this.identifier_ = s;
    }

    public void setLocation(int location) {
        this.location_ = location;
    }

    public void setMaximumValueLength(int length) {
        this.maxValueLength_ = length;
    }

    public void setType(int type) {
        this.type_ = type;
    }

    public byte[] toBytes() {
        byte[] buffer = new byte[this.getByteLength()];
        this.toBytes(buffer, 0);
        return buffer;
    }

    public int toBytes(byte[] buffer, int offset) {
        if (this.getData() == null) {
            return this.toBytesNoData(buffer, offset);
        }
        int struct_offset_id = 28;
        int struct_length_id = this.getIdentifier().length();
        int struct_total_len = this.getByteLength();
        Integer[] fixedData = new Integer[]{new Integer(struct_total_len), new Integer(this.getLocation()), new Integer(this.getType()), new Integer(struct_offset_id), new Integer(struct_length_id)};
        int position = offset;
        position += this.getAttribEntryStruct().toBytes(fixedData, buffer, position);
        position += new AS400Bin4().toBytes(struct_offset_id + struct_length_id, buffer, position);
        position += new AS400Bin4().toBytes(this.getData().getByteLength(), buffer, position);
        position += new AS400Text(struct_length_id, this.getAS400()).toBytes(this.getIdentifier(), buffer, position);
        position += this.getData().toBytes(buffer, position);
        return struct_total_len;
    }

    private int toBytesNoData(byte[] buffer, int offset) {
        int struct_offset_id = 24;
        int struct_length_id = this.getIdentifier().length();
        int struct_total_len = this.getByteLength();
        Integer[] fixedData = new Integer[]{new Integer(struct_total_len), new Integer(this.getLocation()), new Integer(this.getType()), new Integer(struct_offset_id), new Integer(struct_length_id)};
        int position = offset;
        position += this.getAttribEntryStruct().toBytes(fixedData, buffer, position);
        position += new AS400Bin4().toBytes(24 + this.getMaximumValueLength(), buffer, position);
        position += new AS400Text(struct_length_id, this.getAS400()).toBytes(this.getIdentifier(), buffer, position);
        return struct_total_len;
    }
}

