/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.config;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.config.IHopConfigSerializer;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.json.HopJson;
import org.apache.hop.core.vfs.HopVfs;

public class ConfigFileSerializer
implements IHopConfigSerializer {
    @Override
    public void writeToFile(String filename, Map<String, Object> configMap) throws HopException {
        try {
            ObjectMapper objectMapper = HopJson.newMapper();
            DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
            prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
            String niceJson = objectMapper.writer((PrettyPrinter)prettyPrinter).writeValueAsString(configMap);
            FileObject newFile = HopVfs.getFileObject(filename + ".new");
            if (newFile.exists() && !newFile.delete()) {
                throw new HopException("Unable to delete new config file " + newFile.getName().getURI());
            }
            OutputStream outputStream = HopVfs.getOutputStream(newFile, false);
            outputStream.write(niceJson.getBytes(StandardCharsets.UTF_8));
            outputStream.close();
            FileObject oldFile = HopVfs.getFileObject(filename + ".old");
            if (oldFile.exists() && !oldFile.delete()) {
                throw new HopException("Unable to delete old config file " + oldFile.getName().getURI());
            }
            FileObject file = HopVfs.getFileObject(filename);
            if (file.exists() && !file.canRenameTo(oldFile)) {
                throw new HopException("Unable to rename config file to .old : " + file.getName().getURI());
            }
            newFile.moveTo(file);
        }
        catch (Exception e) {
            throw new HopException("Error writing to Hop configuration file : " + filename, e);
        }
    }

    @Override
    public Map<String, Object> readFromFile(String filename) throws HopException {
        Map map;
        block9: {
            FileObject file = HopVfs.getFileObject(filename);
            if (!file.exists()) {
                return new HashMap<String, Object>();
            }
            ObjectMapper objectMapper = HopJson.newMapper();
            TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
            InputStream inputStream = HopVfs.getInputStream(file);
            try {
                map = (Map)objectMapper.readValue(inputStream, (TypeReference)typeRef);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new HopException("Error reading Hop configuration file " + filename, e);
                }
            }
            inputStream.close();
        }
        return map;
    }
}

