/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.pgbulkloader;

import com.google.common.annotations.VisibleForTesting;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.pgbulkloader.PGBulkLoaderData;
import org.apache.hop.pipeline.transforms.pgbulkloader.PGBulkLoaderMappingMeta;
import org.apache.hop.pipeline.transforms.pgbulkloader.PGBulkLoaderMeta;
import org.postgresql.PGConnection;
import org.postgresql.copy.PGCopyOutputStream;

public class PGBulkLoader
extends BaseTransform<PGBulkLoaderMeta, PGBulkLoaderData> {
    private static final Class<?> PKG = PGBulkLoaderMeta.class;
    private Charset clientEncoding = Charset.defaultCharset();
    private PGCopyOutputStream pgCopyOut;

    public PGBulkLoader(TransformMeta transformMeta, PGBulkLoaderMeta meta, PGBulkLoaderData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public String getCopyCommand() throws HopException {
        DatabaseMeta dm = this.getPipelineMeta().findDatabase(((PGBulkLoaderMeta)this.meta).getConnection(), this.variables);
        StringBuilder contents = new StringBuilder(500);
        String tableName = dm.getQuotedSchemaTableCombination((IVariables)this, ((PGBulkLoaderMeta)this.meta).getSchemaName(), ((PGBulkLoaderMeta)this.meta).getTableName());
        contents.append("COPY ");
        contents.append(tableName);
        contents.append(" ( ");
        List<PGBulkLoaderMappingMeta> mapping = ((PGBulkLoaderMeta)this.meta).getMappings();
        if (Utils.isEmpty(mapping)) {
            throw new HopException("No fields defined to load to database");
        }
        for (int i = 0; i < mapping.size(); ++i) {
            if (i != 0) {
                contents.append(", ");
            }
            contents.append(dm.quoteField(mapping.get(i).getFieldTable()));
        }
        contents.append(" ) ");
        contents.append(" FROM STDIN");
        contents.append(" WITH CSV DELIMITER AS '").append(this.resolve(((PGBulkLoaderMeta)this.meta).getDelimiter())).append("' QUOTE AS '").append(this.resolve(((PGBulkLoaderMeta)this.meta).getEnclosure())).append("'");
        contents.append(";").append(Const.CR);
        return contents.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkClientEncoding() throws Exception {
        Connection connection = ((PGBulkLoaderData)this.data).db.getConnection();
        try (Statement statement = connection.createStatement();
             ResultSet rs = statement.executeQuery("show client_encoding");){
            if (!rs.next() || rs.getMetaData().getColumnCount() != 1) {
                this.logBasic("Cannot detect client_encoding, using system default encoding");
                return;
            }
            String clientEncodingStr = rs.getString(1);
            this.logBasic("Detect client_encoding: " + clientEncodingStr);
            this.clientEncoding = Charset.forName(clientEncodingStr);
        }
    }

    private void doCopy(PGBulkLoaderMeta meta, boolean wait) throws HopException {
        ((PGBulkLoaderData)this.data).db = this.getDatabase((ILoggingObject)this, meta);
        String copyCmd = this.getCopyCommand();
        try {
            this.connect();
            this.checkClientEncoding();
            this.processTruncate();
            this.logBasic("Launching command: " + copyCmd);
            this.pgCopyOut = new PGCopyOutputStream((PGConnection)((PGBulkLoaderData)this.data).db.getConnection(), copyCmd);
        }
        catch (Exception ex) {
            throw new HopException("Error while preparing the COPY " + copyCmd, (Throwable)ex);
        }
    }

    @VisibleForTesting
    Database getDatabase(ILoggingObject parentObject, PGBulkLoaderMeta pgBulkLoaderMeta) {
        DatabaseMeta dbMeta = this.getPipelineMeta().findDatabase(((PGBulkLoaderMeta)this.meta).getConnection(), this.variables);
        String dbNameOverride = this.resolve(pgBulkLoaderMeta.getDbNameOverride());
        if (!Utils.isEmpty((CharSequence)dbNameOverride)) {
            dbMeta.setDBName(dbNameOverride.trim());
            this.logDebug("DB name overridden to the value: " + dbNameOverride);
        }
        return new Database(parentObject, this.variables, dbMeta);
    }

    void connect() throws HopException {
        ((PGBulkLoaderData)this.data).db.connect();
    }

    void processTruncate() throws Exception {
        Connection connection = ((PGBulkLoaderData)this.data).db.getConnection();
        String loadAction = this.resolve(((PGBulkLoaderMeta)this.meta).getLoadAction());
        if (loadAction.equalsIgnoreCase("truncate")) {
            DatabaseMeta dm = this.getPipelineMeta().findDatabase(((PGBulkLoaderMeta)this.meta).getConnection(), this.variables);
            String tableName = dm.getQuotedSchemaTableCombination((IVariables)this, ((PGBulkLoaderMeta)this.meta).getSchemaName(), ((PGBulkLoaderMeta)this.meta).getTableName());
            this.logBasic("Launching command: TRUNCATE " + tableName);
            try (Statement statement = connection.createStatement();){
                statement.executeUpdate("TRUNCATE " + tableName);
            }
        }
    }

    public boolean processRow() throws HopException {
        try {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                if (this.data != null && this.pgCopyOut != null) {
                    this.pgCopyOut.flush();
                    this.pgCopyOut.endCopy();
                    this.pgCopyOut.close();
                    ((PGBulkLoaderData)this.data).db.getConnection().close();
                }
                return false;
            }
            if (this.first) {
                this.first = false;
                ((PGBulkLoaderData)this.data).keynrs = new int[((PGBulkLoaderMeta)this.meta).getMappings().size()];
                for (int i = 0; i < ((PGBulkLoaderData)this.data).keynrs.length; ++i) {
                    ((PGBulkLoaderData)this.data).keynrs[i] = this.getInputRowMeta().indexOfValue(((PGBulkLoaderMeta)this.meta).getMappings().get(i).getFieldStream());
                }
                this.doCopy((PGBulkLoaderMeta)this.meta, true);
            }
            this.writeRowToPostgres(this.getInputRowMeta(), r);
            this.putRow(this.getInputRowMeta(), r);
            this.incrementLinesOutput();
            return true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"GPBulkLoader.Log.ErrorInTransform", (String[])new String[0]), e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
    }

    private void writeRowToPostgres(IRowMeta rowMeta, Object[] r) throws HopException {
        try {
            block21: for (int i = 0; i < ((PGBulkLoaderData)this.data).keynrs.length; ++i) {
                if (i > 0) {
                    this.pgCopyOut.write(((PGBulkLoaderData)this.data).separator);
                }
                int index = ((PGBulkLoaderData)this.data).keynrs[i];
                IValueMeta valueMeta = rowMeta.getValueMeta(index);
                Object valueData = r[index];
                if (valueData == null) continue;
                switch (valueMeta.getType()) {
                    case 2: {
                        this.pgCopyOut.write(((PGBulkLoaderData)this.data).quote);
                        String quoteStr = new String(((PGBulkLoaderData)this.data).quote);
                        String escapedString = valueMeta.getString(valueData).replace(quoteStr, quoteStr + quoteStr);
                        this.pgCopyOut.write(escapedString.getBytes(this.clientEncoding));
                        this.pgCopyOut.write(((PGBulkLoaderData)this.data).quote);
                        continue block21;
                    }
                    case 5: {
                        if (valueMeta.isStorageBinaryString()) {
                            this.pgCopyOut.write((byte[])valueData);
                            continue block21;
                        }
                        this.pgCopyOut.write(Long.toString(valueMeta.getInteger(valueData)).getBytes(this.clientEncoding));
                        continue block21;
                    }
                    case 3: {
                        String dateTimeString;
                        String dateString;
                        switch (((PGBulkLoaderData)this.data).dateFormatChoices[i]) {
                            case 0: {
                                if (valueMeta.isStorageBinaryString()) {
                                    this.pgCopyOut.write((byte[])valueData);
                                    continue block21;
                                }
                                dateString = valueMeta.getString(valueData);
                                if (dateString == null) continue block21;
                                this.pgCopyOut.write(dateString.getBytes(this.clientEncoding));
                                continue block21;
                            }
                            case 1: {
                                dateString = ((PGBulkLoaderData)this.data).dateMeta.getString((Object)valueMeta.getDate(valueData));
                                if (dateString == null) continue block21;
                                this.pgCopyOut.write(dateString.getBytes(this.clientEncoding));
                                continue block21;
                            }
                            case 2: {
                                dateTimeString = ((PGBulkLoaderData)this.data).dateTimeMeta.getString((Object)valueMeta.getDate(valueData));
                                if (dateTimeString == null) continue block21;
                                this.pgCopyOut.write(dateTimeString.getBytes(this.clientEncoding));
                                continue block21;
                            }
                            default: {
                                throw new HopException("PGBulkLoader doesn't know how to handle date (neither passthrough, nor date or datetime for field " + valueMeta.getName());
                            }
                        }
                    }
                    case 9: {
                        String dateTimeString;
                        String dateString;
                        switch (((PGBulkLoaderData)this.data).dateFormatChoices[i]) {
                            case 0: {
                                if (valueMeta.isStorageBinaryString()) {
                                    this.pgCopyOut.write((byte[])valueData);
                                    continue block21;
                                }
                                dateString = valueMeta.getString(valueData);
                                if (dateString == null) continue block21;
                                this.pgCopyOut.write(dateString.getBytes(this.clientEncoding));
                                continue block21;
                            }
                            case 1: {
                                dateString = ((PGBulkLoaderData)this.data).dateMeta.getString((Object)valueMeta.getDate(valueData));
                                if (dateString == null) continue block21;
                                this.pgCopyOut.write(dateString.getBytes(this.clientEncoding));
                                continue block21;
                            }
                            case 2: {
                                dateTimeString = ((PGBulkLoaderData)this.data).dateTimeMeta.getString((Object)valueMeta.getDate(valueData));
                                if (dateTimeString == null) continue block21;
                                this.pgCopyOut.write(dateTimeString.getBytes(this.clientEncoding));
                                continue block21;
                            }
                            default: {
                                throw new HopException("PGBulkLoader doesn't know how to handle timestamp (neither passthrough, nor date or datetime for field " + valueMeta.getName());
                            }
                        }
                    }
                    case 4: {
                        if (valueMeta.isStorageBinaryString()) {
                            this.pgCopyOut.write((byte[])valueData);
                            continue block21;
                        }
                        this.pgCopyOut.write(Double.toString(valueMeta.getNumber(valueData)).getBytes(this.clientEncoding));
                        continue block21;
                    }
                    case 1: {
                        if (valueMeta.isStorageBinaryString()) {
                            this.pgCopyOut.write((byte[])valueData);
                            continue block21;
                        }
                        this.pgCopyOut.write(Double.toString(valueMeta.getNumber(valueData)).getBytes(this.clientEncoding));
                        continue block21;
                    }
                    case 6: {
                        if (valueMeta.isStorageBinaryString()) {
                            this.pgCopyOut.write((byte[])valueData);
                            continue block21;
                        }
                        BigDecimal big = valueMeta.getBigNumber(valueData);
                        if (big == null) continue block21;
                        this.pgCopyOut.write(big.toString().getBytes(this.clientEncoding));
                        continue block21;
                    }
                    default: {
                        if (valueMeta.getType() == ValueMetaFactory.getIdForValueMeta((String)"UUID")) {
                            if (valueMeta.isStorageBinaryString()) {
                                this.pgCopyOut.write((byte[])valueData);
                                continue block21;
                            }
                            String s = valueMeta.getString(valueData);
                            if (s == null) continue block21;
                            this.pgCopyOut.write(s.getBytes(this.clientEncoding));
                            continue block21;
                        }
                        throw new HopException("PGBulkLoader doesn't handle the type " + valueMeta.getTypeDesc());
                    }
                }
            }
            this.pgCopyOut.write(((PGBulkLoaderData)this.data).newline);
        }
        catch (Exception e) {
            throw new HopException("Error serializing rows of data to the COPY command", (Throwable)e);
        }
    }

    protected void verifyDatabaseConnection() throws HopException {
        if (((PGBulkLoaderMeta)this.meta).getConnection() == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"PGBulkLoaderMeta.GetSQL.NoConnectionDefined", (String[])new String[0]));
        }
    }

    public boolean init() {
        String enclosure = this.resolve(((PGBulkLoaderMeta)this.meta).getEnclosure());
        String separator = this.resolve(((PGBulkLoaderMeta)this.meta).getDelimiter());
        if (super.init()) {
            try {
                this.verifyDatabaseConnection();
            }
            catch (HopException ex) {
                this.logError(ex.getMessage());
                return false;
            }
            ((PGBulkLoaderData)this.data).quote = enclosure != null ? enclosure.getBytes() : new byte[0];
            ((PGBulkLoaderData)this.data).separator = separator != null ? separator.getBytes() : new byte[0];
            ((PGBulkLoaderData)this.data).newline = Const.CR.getBytes();
            ((PGBulkLoaderData)this.data).dateFormatChoices = new int[((PGBulkLoaderMeta)this.meta).getMappings().size()];
            for (int i = 0; i < ((PGBulkLoaderData)this.data).dateFormatChoices.length; ++i) {
                ((PGBulkLoaderData)this.data).dateFormatChoices[i] = Utils.isEmpty((CharSequence)((PGBulkLoaderMeta)this.meta).getMappings().get(i).getDateMask()) ? 0 : (((PGBulkLoaderMeta)this.meta).getMappings().get(i).getDateMask().equalsIgnoreCase("DATE") ? 1 : (((PGBulkLoaderMeta)this.meta).getMappings().get(i).getDateMask().equalsIgnoreCase("DATETIME") ? 2 : 0));
            }
            return true;
        }
        return false;
    }
}

