/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.s2a.internal.handshaker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import io.grpc.s2a.internal.handshaker.TLSVersion;

final class ProtoUtil {
    @VisibleForTesting
    static String convertTlsProtocolVersion(TLSVersion tlsVersion) {
        switch (tlsVersion) {
            case TLS_VERSION_1_3: {
                return "TLSv1.3";
            }
            case TLS_VERSION_1_2: {
                return "TLSv1.2";
            }
            case TLS_VERSION_1_1: {
                return "TLSv1.1";
            }
            case TLS_VERSION_1_0: {
                return "TLSv1";
            }
        }
        throw new IllegalArgumentException(String.format("TLS version %d is not supported.", tlsVersion.getNumber()));
    }

    static ImmutableSet<String> buildTlsProtocolVersionSet(TLSVersion minTlsVersion, TLSVersion maxTlsVersion) {
        ImmutableSet.Builder tlsVersions = ImmutableSet.builder();
        for (TLSVersion tlsVersion : TLSVersion.values()) {
            int versionNumber;
            try {
                versionNumber = tlsVersion.getNumber();
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            if (versionNumber < minTlsVersion.getNumber() || versionNumber > maxTlsVersion.getNumber()) continue;
            try {
                tlsVersions.add((Object)ProtoUtil.convertTlsProtocolVersion(tlsVersion));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return tlsVersions.build();
    }

    private ProtoUtil() {
    }
}

