/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.clonerow;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.clonerow.CloneRow;
import org.apache.hop.pipeline.transforms.clonerow.CloneRowData;

@Transform(id="CloneRow", name="i18n::CloneRow.Name", description="i18n::CloneRow.Description", image="clonerow.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Utility", keywords={"i18n::CloneRowMeta.keyword"}, documentationUrl="/pipeline/transforms/clonerow.html")
public class CloneRowMeta
extends BaseTransformMeta<CloneRow, CloneRowData> {
    private static final Class<?> PKG = CloneRowMeta.class;
    @HopMetadataProperty(key="nrclones", injectionKeyDescription="CloneRowMeta.Injection.NrClones")
    private String nrClones;
    @HopMetadataProperty(key="addcloneflag", injectionKeyDescription="CloneRowMeta.Injection.AddCloneFlag")
    private boolean addCloneFlag;
    @HopMetadataProperty(key="cloneflagfield", injectionKeyDescription="CloneRowMeta.Injection.CloneFlagField")
    private String cloneFlagField;
    @HopMetadataProperty(key="nrcloneinfield", injectionKeyDescription="CloneRowMeta.Injection.NrCloneInField")
    private boolean nrCloneInField;
    @HopMetadataProperty(key="nrclonefield", injectionKeyDescription="CloneRowMeta.Injection.NrCloneField")
    private String nrCloneField;
    @HopMetadataProperty(key="addclonenum", injectionKeyDescription="CloneRowMeta.Injection.AddCloneNum")
    private boolean addCloneNum;
    @HopMetadataProperty(key="clonenumfield", injectionKeyDescription="CloneRowMeta.Injection.CloneNumField")
    private String cloneNumField;

    public String getNrClones() {
        return this.nrClones;
    }

    public void setNrClones(String nrclones) {
        this.nrClones = nrclones;
    }

    public boolean isAddCloneFlag() {
        return this.addCloneFlag;
    }

    public void setAddCloneFlag(boolean addcloneflag) {
        this.addCloneFlag = addcloneflag;
    }

    public boolean isNrCloneInField() {
        return this.nrCloneInField;
    }

    public void setNrCloneInField(boolean nrcloneinfield) {
        this.nrCloneInField = nrcloneinfield;
    }

    public boolean isAddCloneNum() {
        return this.addCloneNum;
    }

    public void setAddCloneNum(boolean addclonenum) {
        this.addCloneNum = addclonenum;
    }

    public String getCloneNumField() {
        return this.cloneNumField;
    }

    public void setCloneNumField(String clonenumfield) {
        this.cloneNumField = clonenumfield;
    }

    public String getNrCloneField() {
        return this.nrCloneField;
    }

    public void setNrCloneField(String nrclonefield) {
        this.nrCloneField = nrclonefield;
    }

    public String getCloneFlagField() {
        return this.cloneFlagField;
    }

    public void setCloneFlagField(String cloneflagfield) {
        this.cloneFlagField = cloneflagfield;
    }

    public void setDefault() {
        this.nrClones = "0";
        this.cloneFlagField = null;
        this.nrCloneField = null;
        this.nrCloneInField = false;
        this.addCloneFlag = false;
        this.addCloneNum = false;
        this.cloneNumField = null;
    }

    public void getFields(IRowMeta rowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaBoolean v;
        String realfieldValue;
        if (this.addCloneFlag && !Utils.isEmpty((CharSequence)(realfieldValue = variables.resolve(this.cloneFlagField)))) {
            v = new ValueMetaBoolean(realfieldValue);
            v.setOrigin(origin);
            rowMeta.addValueMeta((IValueMeta)v);
        }
        if (this.addCloneNum && !Utils.isEmpty((CharSequence)(realfieldValue = variables.resolve(this.cloneNumField)))) {
            v = new ValueMetaInteger(realfieldValue);
            v.setOrigin(origin);
            rowMeta.addValueMeta((IValueMeta)v);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        String errorMessage = "";
        if (Utils.isEmpty((CharSequence)this.nrClones)) {
            errorMessage = BaseMessages.getString(PKG, (String)"CloneRowMeta.CheckResult.NrClonesdMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"CloneRowMeta.CheckResult.NrClonesOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
        }
        remarks.add((ICheckResult)cr);
        if (this.addCloneFlag) {
            if (Utils.isEmpty((CharSequence)this.cloneFlagField)) {
                errorMessage = BaseMessages.getString(PKG, (String)"CloneRowMeta.CheckResult.CloneFlagFieldMissing", (String[])new String[0]);
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            } else {
                errorMessage = BaseMessages.getString(PKG, (String)"CloneRowMeta.CheckResult.CloneFlagFieldOk", (String[])new String[0]);
                cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            }
            remarks.add((ICheckResult)cr);
        }
        if (this.addCloneNum) {
            if (Utils.isEmpty((CharSequence)this.cloneNumField)) {
                errorMessage = BaseMessages.getString(PKG, (String)"CloneRowMeta.CheckResult.CloneNumFieldMissing", (String[])new String[0]);
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            } else {
                errorMessage = BaseMessages.getString(PKG, (String)"CloneRowMeta.CheckResult.CloneNumFieldOk", (String[])new String[0]);
                cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            }
            remarks.add((ICheckResult)cr);
        }
        if (this.nrCloneInField) {
            if (Utils.isEmpty((CharSequence)this.nrCloneField)) {
                errorMessage = BaseMessages.getString(PKG, (String)"CloneRowMeta.CheckResult.NrCloneFieldMissing", (String[])new String[0]);
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            } else {
                errorMessage = BaseMessages.getString(PKG, (String)"CloneRowMeta.CheckResult.NrCloneFieldOk", (String[])new String[0]);
                cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            }
            remarks.add((ICheckResult)cr);
        }
        cr = prev == null || prev.isEmpty() ? new CheckResult(3, BaseMessages.getString(PKG, (String)"CloneRowMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"CloneRowMeta.CheckResult.TransformRecevingData", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"CloneRowMeta.CheckResult.TransformRecevingData2", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"CloneRowMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }
}

