/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.util.Weighted;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@Internal
public final class WeightedValue<@UnknownKeyFor T>
implements Weighted {
    private final T value;
    private final @UnknownKeyFor @NonNull @Initialized long weight;

    private WeightedValue(T value, @UnknownKeyFor @NonNull @Initialized long weight) {
        this.value = value;
        this.weight = weight;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized WeightedValue<T> of(T value, @UnknownKeyFor @NonNull @Initialized long weight) {
        return new WeightedValue<T>(value, weight);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getWeight() {
        return this.weight;
    }

    public T getValue() {
        return this.value;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WeightedValue)) {
            return false;
        }
        WeightedValue that = (WeightedValue)o;
        return this.weight == that.weight && Objects.equals(this.value, that.value);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.value, this.weight);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "WeightedValue{value=" + this.value + ", weight=" + this.weight + "}";
    }
}

