/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.netpreserve.jwarc.MessageHeaders;

public class HeaderValidator {
    private final Map<String, FieldRule> fields = new TreeMap<String, FieldRule>(String.CASE_INSENSITIVE_ORDER);
    private final Set<String> mandatoryFields = new HashSet<String>();
    private final Map<String, Set<String>> mandatoryFieldsByRecordType = new HashMap<String, Set<String>>();
    private boolean forbidUnknownFields = false;

    private HeaderValidator() {
    }

    public static HeaderValidator warc_1_1() {
        return HeaderValidator.warc_1_1(false);
    }

    public static HeaderValidator warc_1_1(boolean forbidExtensions) {
        String uriRegex = "(?:[a-zA-Z][a-zA-Z0-9+.-]*:)?.*";
        Pattern backwardsCompatibleUri = Pattern.compile("<" + uriRegex + ">|" + uriRegex);
        Pattern uri = Pattern.compile(uriRegex);
        Pattern recordId = Pattern.compile("<" + uriRegex + ">");
        Pattern nonNegativeInteger = Pattern.compile("[0-9]+");
        Pattern date = Pattern.compile("\\d{4}(-\\d{2}(-\\d{2}(T\\d{2}:\\d{2}(:\\d{2}(\\.\\d+)?(Z|[+-]\\d{2}:\\d{2})?)?)?)?)?");
        String ows = "[ \\t]*";
        String token = "[-!#$%&'*+.^_`|~0-9A-Za-z]+";
        String quotedString = "\"(?:[^\"\\x00-\\x1F\\x7F]|\\\\.)*\"";
        String value = token + "|" + quotedString;
        String parameter = token + "=(" + value + ")";
        Pattern mediaType = Pattern.compile(token + "/" + token + ows + "(?:;" + ows + parameter + ")*");
        String digestValue = "[-!#$%&'*+.^_`|~0-9A-Za-z/@]+";
        Pattern labelledDigest = Pattern.compile(token + ":" + digestValue);
        HeaderValidator v = new HeaderValidator();
        v.forbidUnknownFields = forbidExtensions;
        v.field("WARC-Record-ID").mandatory().pattern(recordId);
        v.field("Content-Length").mandatory().pattern(nonNegativeInteger);
        v.field("WARC-Date").mandatory().pattern(date);
        v.field("WARC-Type").mandatory().pattern(forbidExtensions ? Pattern.compile("warcinfo|response|resource|request|metadata|revisit|conversion|continuation") : null);
        v.field("Content-Type").pattern(mediaType);
        v.field("WARC-Concurrent-To").pattern(recordId).repeatable().forbidOn("warcinfo", "conversion", "continuation");
        v.field("WARC-Block-Digest").pattern(labelledDigest);
        v.field("WARC-Payload-Digest").pattern(labelledDigest);
        v.field("WARC-IP-Address").forbidOn("warcinfo", "conversion", "continuation");
        v.field("WARC-Refers-To").pattern(recordId).forbidOn("warcinfo", "response", "resource", "request", "continuation");
        v.field("WARC-Refers-To-Target-URI").pattern(uri).forbidOn("warcinfo", "response", "metadata", "conversion", "resource", "request", "continuation");
        v.field("WARC-Refers-To-Date").pattern(date).forbidOn("warcinfo", "response", "metadata", "conversion", "resource", "request", "continuation");
        v.field("WARC-Target-URI").pattern(backwardsCompatibleUri).forbidOn("warcinfo").requireOn("response", "resource", "request", "revisit", "conversion", "continuation");
        v.field("WARC-Truncated").pattern(forbidExtensions ? Pattern.compile("length|time|disconnect|unspecified") : null);
        v.field("WARC-Warcinfo-ID").pattern(recordId).forbidOn("warcinfo");
        v.field("WARC-Filename").forbidOn("revisit", "response", "metadata", "conversion", "resource", "request", "continuation");
        FieldRule profileField = v.field("WARC-Profile").requireOn("revisit");
        if (forbidExtensions) {
            profileField.pattern(Pattern.compile("\\Qhttp://netpreserve.org/warc/1.1/revisit/identical-payload-digest\\E|\\Qhttp://netpreserve.org/warc/1.1/revisit/server-not-modified\\E"));
            profileField.forbidOn("warcinfo", "response", "metadata", "conversion", "resource", "request", "continuation");
        } else {
            profileField.pattern(backwardsCompatibleUri);
        }
        v.field("WARC-Identified-Payload-Type").pattern(mediaType);
        v.field("WARC-Segment-Number").pattern(nonNegativeInteger);
        v.field("WARC-Segment-Origin-ID").pattern(nonNegativeInteger).requireOn("continuation").forbidOn("warcinfo", "response", "metadata", "conversion", "resource", "request", "revisit");
        v.field("WARC-Segment-Total-Length").pattern(nonNegativeInteger).forbidOn("warcinfo", "response", "metadata", "conversion", "resource", "request", "revisit");
        return v;
    }

    private FieldRule field(String name) {
        return this.fields.computeIfAbsent(name, x$0 -> new FieldRule((String)x$0));
    }

    public List<String> validate(MessageHeaders headers) {
        ArrayList<String> violations = new ArrayList<String>();
        String recordType = headers.first("WARC-Type").orElse(null);
        for (Map.Entry<String, List<String>> entry : headers.map().entrySet()) {
            String name = entry.getKey();
            List<String> values = entry.getValue();
            FieldRule fieldRule = this.fields.get(name);
            if (fieldRule == null) {
                if (!this.forbidUnknownFields) continue;
                violations.add("Unknown field: " + name);
                continue;
            }
            if (!fieldRule.repeatable && values.size() > 1) {
                violations.add("Field must not be repeated: " + name);
            }
            if (recordType != null && fieldRule.forbiddenOn.contains(recordType)) {
                violations.add("Field not allowed on " + recordType + " record: " + name);
            }
            if (fieldRule.pattern == null) continue;
            for (String value : values) {
                if (fieldRule.pattern.matcher(value).matches()) continue;
                violations.add("Field has invalid value: " + value);
            }
        }
        Set<String> names = headers.map().keySet();
        for (String field : this.mandatoryFields) {
            if (names.contains(field)) continue;
            violations.add("Missing mandatory field: " + field);
        }
        if (recordType != null) {
            for (String name : this.mandatoryFieldsByRecordType.getOrDefault(recordType, Collections.emptySet())) {
                if (names.contains(name)) continue;
                violations.add("Missing mandatory field for " + recordType + " record: " + name);
            }
        }
        return violations;
    }

    class FieldRule {
        final String name;
        Pattern pattern;
        boolean repeatable;
        final Set<String> forbiddenOn = new HashSet<String>();

        public FieldRule(String name) {
            this.name = name;
        }

        public FieldRule mandatory() {
            HeaderValidator.this.mandatoryFields.add(this.name);
            return this;
        }

        public FieldRule pattern(Pattern pattern) {
            this.pattern = pattern;
            return this;
        }

        public FieldRule repeatable() {
            this.repeatable = true;
            return this;
        }

        public FieldRule forbidOn(String ... recordTypes) {
            Collections.addAll(this.forbiddenOn, recordTypes);
            return this;
        }

        public FieldRule requireOn(String ... recordTypes) {
            for (String recordType : recordTypes) {
                HeaderValidator.this.mandatoryFieldsByRecordType.computeIfAbsent(recordType, k -> new TreeSet(String.CASE_INSENSITIVE_ORDER)).add(this.name);
            }
            return this;
        }
    }
}

