/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.formula;

import java.io.IOException;
import java.util.function.Consumer;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FormulaPoi {
    private final Consumer<String> log;
    private XSS slow;
    private HSS fast;

    public FormulaPoi(Consumer<String> log) {
        this.log = log;
    }

    public Evaluator evaluator(int columns) {
        return columns <= 256 ? (this.fast == null ? (this.fast = new HSS()) : this.fast).incr() : (this.slow == null ? (this.slow = new XSS()) : this.slow);
    }

    public void reset() {
        if (this.fast != null) {
            this.fast.currentCount = HSS.RESET_INTERVAL;
            this.fast.incr();
        }
    }

    public void destroy() throws IOException {
        if (this.slow != null) {
            this.slow.workBook.close();
        }
        if (this.fast != null) {
            this.fast.workBook.close();
        }
    }

    private static class HSS
    implements Evaluator {
        private static final int RESET_INTERVAL = Integer.getInteger(HSS.class.getName().replace('$', '.') + ".resetInterval", 10000);
        private HSSFWorkbook workBook;
        private HSSFSheet workSheet;
        private HSSFRow sheetRow;
        private HSSFFormulaEvaluator evaluator;
        private int currentCount = RESET_INTERVAL;

        private HSS() {
            this.incr();
        }

        @Override
        public Sheet sheet() {
            return this.workSheet;
        }

        @Override
        public Row row() {
            return this.sheetRow;
        }

        @Override
        public void row(Row row) {
            this.sheetRow = (HSSFRow)row;
        }

        @Override
        public FormulaEvaluator evaluator() {
            return this.evaluator;
        }

        public Evaluator incr() {
            if (this.currentCount++ == RESET_INTERVAL) {
                this.workBook = new HSSFWorkbook();
                this.workSheet = this.workBook.createSheet();
                this.sheetRow = this.workSheet.createRow(0);
                this.evaluator = this.sheetRow.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
                this.currentCount = 0;
            }
            return this;
        }
    }

    public static interface Evaluator {
        public Sheet sheet();

        public Row row();

        public void row(Row var1);

        public FormulaEvaluator evaluator();
    }

    private class XSS
    implements Evaluator {
        private final XSSFWorkbook workBook;
        private final XSSFSheet workSheet;
        private XSSFRow sheetRow;
        private final XSSFFormulaEvaluator evaluator;

        private XSS() {
            FormulaPoi.this.log.accept("using xss implementation which is slow");
            this.workBook = new XSSFWorkbook();
            this.workBook.setCellFormulaValidation(false);
            this.workSheet = this.workBook.createSheet();
            this.sheetRow = this.workSheet.createRow(0);
            this.evaluator = this.sheetRow.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
        }

        @Override
        public Sheet sheet() {
            return this.workSheet;
        }

        @Override
        public Row row() {
            return this.sheetRow;
        }

        @Override
        public void row(Row row) {
            this.sheetRow = (XSSFRow)row;
        }

        @Override
        public FormulaEvaluator evaluator() {
            return this.evaluator;
        }
    }
}

