/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.text.TextDisplayAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextOutlineLevelAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

public class TextChapterElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "chapter");

    public TextChapterElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getTextDisplayAttribute() {
        TextDisplayAttribute attr = (TextDisplayAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "display");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextDisplayAttribute(String textDisplayValue) {
        TextDisplayAttribute attr = new TextDisplayAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textDisplayValue);
    }

    public Integer getTextOutlineLevelAttribute() {
        TextOutlineLevelAttribute attr = (TextOutlineLevelAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "outline-level");
        if (attr != null) {
            return attr.intValue();
        }
        return null;
    }

    public void setTextOutlineLevelAttribute(Integer textOutlineLevelValue) {
        TextOutlineLevelAttribute attr = new TextOutlineLevelAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setIntValue(textOutlineLevelValue);
    }

    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }

    public void newTextNode(String content) {
        if (content != null && !content.equals("")) {
            this.appendChild(this.getOwnerDocument().createTextNode(content));
        }
    }
}

