/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.serverstatus;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.serverstatus.GetServerStatusData;
import org.apache.hop.pipeline.transforms.serverstatus.GetServerStatusMeta;
import org.apache.hop.server.HopServerMeta;
import org.apache.hop.www.HopServerPipelineStatus;
import org.apache.hop.www.HopServerStatus;
import org.apache.hop.www.HopServerWorkflowStatus;

public class GetServerStatus
extends BaseTransform<GetServerStatusMeta, GetServerStatusData> {
    public GetServerStatus(TransformMeta transformMeta, GetServerStatusMeta meta, GetServerStatusData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processRow() throws HopException {
        long endTime;
        String errorMessage;
        Object[] row = this.getRow();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((GetServerStatusData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((GetServerStatusMeta)this.meta).getFields(((GetServerStatusData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((GetServerStatusData)this.data).serverFieldIndex = this.getInputRowMeta().indexOfValue(((GetServerStatusMeta)this.meta).getServerField());
            if (((GetServerStatusData)this.data).serverFieldIndex < 0) {
                throw new HopException("Unable to find hop server field '" + ((GetServerStatusMeta)this.meta).getServerField());
            }
        }
        String serverName = this.getInputRowMeta().getString(row, ((GetServerStatusData)this.data).serverFieldIndex);
        HopServerMeta hopServer = (HopServerMeta)this.metadataProvider.getSerializer(HopServerMeta.class).load(serverName);
        if (hopServer == null) {
            throw new HopException("Hop server '" + serverName + "' couldn't be found");
        }
        String statusDescription = null;
        Double serverLoad = null;
        Long memoryFree = null;
        Long memoryTotal = null;
        Long cpuCores = null;
        Long cpuProcessTime = null;
        String osName = null;
        String osVersion = null;
        String osArchitecture = null;
        Long activePipelines = null;
        Long activeWorkflows = null;
        Boolean available = null;
        Long responseNs = null;
        long startTime = System.nanoTime();
        try {
            Long l;
            errorMessage = null;
            HopServerStatus status = hopServer.getStatus((IVariables)this);
            statusDescription = status.getStatusDescription();
            serverLoad = status.getLoadAvg();
            memoryFree = status.getMemoryFree();
            memoryTotal = status.getMemoryTotal();
            cpuCores = status.getCpuCores();
            cpuProcessTime = status.getCpuProcessTime();
            osName = status.getOsName();
            osVersion = status.getOsVersion();
            osArchitecture = status.getOsArchitecture();
            activePipelines = 0L;
            for (HopServerPipelineStatus pipelineStatus : status.getPipelineStatusList()) {
                if (!pipelineStatus.isRunning()) continue;
                l = activePipelines;
                activePipelines = activePipelines + 1L;
            }
            activeWorkflows = 0L;
            for (HopServerWorkflowStatus workflowStatus : status.getWorkflowStatusList()) {
                if (!workflowStatus.isRunning()) continue;
                l = activeWorkflows;
                activeWorkflows = activeWorkflows + 1L;
            }
            available = true;
        }
        catch (Exception e) {
            errorMessage = "Error querying Hop server : " + e.getMessage();
        }
        finally {
            endTime = System.nanoTime();
        }
        responseNs = endTime - startTime;
        Object[] outputRow = RowDataUtil.createResizedCopy((Object[])row, (int)((GetServerStatusData)this.data).outputRowMeta.size());
        int outIndex = this.getInputRowMeta().size();
        if (StringUtils.isNotEmpty((String)((GetServerStatusMeta)this.meta).getErrorMessageField())) {
            outputRow[outIndex++] = errorMessage;
        }
        if (StringUtils.isNotEmpty((String)((GetServerStatusMeta)this.meta).getStatusDescriptionField())) {
            outputRow[outIndex++] = statusDescription;
        }
        if (StringUtils.isNotEmpty((String)((GetServerStatusMeta)this.meta).getServerLoadField())) {
            outputRow[outIndex++] = serverLoad;
        }
        if (StringUtils.isNotEmpty((String)((GetServerStatusMeta)this.meta).getMemoryFreeField())) {
            outputRow[outIndex++] = memoryFree;
        }
        if (StringUtils.isNotEmpty((String)((GetServerStatusMeta)this.meta).getMemoryTotalField())) {
            outputRow[outIndex++] = memoryTotal;
        }
        if (StringUtils.isNotEmpty((String)((GetServerStatusMeta)this.meta).getCpuCoresField())) {
            outputRow[outIndex++] = cpuCores;
        }
        if (StringUtils.isNotEmpty((String)((GetServerStatusMeta)this.meta).getCpuProcessTimeField())) {
            outputRow[outIndex++] = cpuProcessTime;
        }
        if (StringUtils.isNotEmpty((String)((GetServerStatusMeta)this.meta).getOsNameField())) {
            outputRow[outIndex++] = osName;
        }
        if (StringUtils.isNotEmpty((String)((GetServerStatusMeta)this.meta).getOsVersionField())) {
            outputRow[outIndex++] = osVersion;
        }
        if (StringUtils.isNotEmpty((String)((GetServerStatusMeta)this.meta).getOsArchitectureField())) {
            outputRow[outIndex++] = osArchitecture;
        }
        if (StringUtils.isNotEmpty((String)((GetServerStatusMeta)this.meta).getActivePipelinesField())) {
            outputRow[outIndex++] = activePipelines;
        }
        if (StringUtils.isNotEmpty((String)((GetServerStatusMeta)this.meta).getActiveWorkflowsField())) {
            outputRow[outIndex++] = activeWorkflows;
        }
        if (StringUtils.isNotEmpty((String)((GetServerStatusMeta)this.meta).getAvailableField())) {
            outputRow[outIndex++] = available;
        }
        if (StringUtils.isNotEmpty((String)((GetServerStatusMeta)this.meta).getResponseNsField())) {
            outputRow[outIndex++] = responseNs;
        }
        this.putRow(((GetServerStatusData)this.data).outputRowMeta, outputRow);
        return true;
    }
}

