/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.orabulkloader;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.orabulkloader.OraBulkDataOutput;
import org.apache.hop.pipeline.transforms.orabulkloader.OraBulkLoaderData;
import org.apache.hop.pipeline.transforms.orabulkloader.OraBulkLoaderMappingMeta;
import org.apache.hop.pipeline.transforms.orabulkloader.OraBulkLoaderMeta;

public class OraBulkLoader
extends BaseTransform<OraBulkLoaderMeta, OraBulkLoaderData> {
    private static final Class<?> PKG = OraBulkLoaderMeta.class;
    public static final int EX_SUCC = 0;
    public static final int EX_WARN = 2;
    public static final String CONST_ORA_BULK_LOADER_LOG_EXIT_VALUE_SQLLDR = "OraBulkLoader.Log.ExitValueSqlldr";
    private Process sqlldrProcess = null;
    private OraBulkDataOutput output = null;
    private boolean preview = false;

    public OraBulkLoader(TransformMeta transformMeta, OraBulkLoaderMeta meta, OraBulkLoaderData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private String substituteRecordTerminator(String terminator) {
        StringBuilder in = new StringBuilder();
        boolean escaped = false;
        terminator = this.resolve(terminator);
        int length = terminator.length();
        for (int i = 0; i < length; ++i) {
            char c = terminator.charAt(i);
            if (escaped) {
                switch (c) {
                    case 'n': {
                        in.append('\n');
                        break;
                    }
                    case 'r': {
                        in.append('\r');
                        break;
                    }
                    default: {
                        in.append(c);
                    }
                }
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            in.append(c);
        }
        return in.toString();
    }

    private String encodeRecordTerminator(String terminator, String encoding) throws HopException {
        String in = this.substituteRecordTerminator(terminator);
        StringBuilder out = new StringBuilder();
        try {
            byte[] bytes = Utils.isEmpty((CharSequence)encoding) ? in.getBytes() : in.getBytes(encoding);
            for (byte aByte : bytes) {
                String hex = Integer.toHexString(aByte);
                if (hex.length() == 1) {
                    out.append('0');
                }
                out.append(hex);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new HopException("Unsupported character encoding: " + encoding, (Throwable)e);
        }
        return out.toString();
    }

    public String getControlFileContents(OraBulkLoaderMeta meta, IRowMeta rowMeta, Object[] row) throws HopException {
        DatabaseMeta dm = this.getPipelineMeta().findDatabase(meta.getConnection(), this.variables);
        String inputName = "'" + this.getFilename(this.getFileObject(meta.getDataFile(), this.variables)) + "'";
        String loadAction = meta.getLoadAction();
        StringBuilder contents = new StringBuilder(500);
        contents.append("OPTIONS(").append(Const.CR);
        contents.append("  ERRORS='").append(meta.getMaxErrors()).append("'").append(Const.CR);
        if (!(meta.getCommitSizeAsInt((IVariables)this) == 0 || meta.isDirectPath() && this.getTransformMeta().getCopies(this.variables) > 1)) {
            contents.append("  , ROWS='").append(meta.getCommitSize()).append("'").append(Const.CR);
        }
        if (meta.getBindSizeAsInt((IVariables)this) != 0) {
            contents.append("  , BINDSIZE='").append(meta.getBindSize()).append("'").append(Const.CR);
        }
        if (meta.getReadSizeAsInt((IVariables)this) != 0) {
            contents.append("  , READSIZE='").append(meta.getReadSize()).append("'").append(Const.CR);
        }
        contents.append(")").append(Const.CR);
        contents.append("LOAD DATA").append(Const.CR);
        if (!Utils.isEmpty((CharSequence)meta.getCharacterSetName())) {
            contents.append("CHARACTERSET ").append(meta.getCharacterSetName()).append(Const.CR);
        }
        if (!"AUTO_CONCURRENT".equals(meta.getLoadMethod()) || !Utils.isEmpty((CharSequence)meta.getAltRecordTerm())) {
            Object infile = inputName;
            if ("AUTO_CONCURRENT".equals(meta.getLoadMethod())) {
                infile = "''";
            }
            contents.append("INFILE ").append((String)infile);
            if (!Utils.isEmpty((CharSequence)meta.getAltRecordTerm())) {
                contents.append(" \"STR x'").append(this.encodeRecordTerminator(meta.getAltRecordTerm(), meta.getEncoding())).append("'\"");
            }
            contents.append(Const.CR);
        }
        contents.append("INTO TABLE ").append(dm.getQuotedSchemaTableCombination(this.variables, meta.getSchemaName(), meta.getTableName())).append(Const.CR).append(loadAction).append(Const.CR).append("FIELDS TERMINATED BY ',' ENCLOSED BY '\"'").append(Const.CR).append("TRAILING NULLCOLS").append(Const.CR).append('(');
        List<OraBulkLoaderMappingMeta> mappings = meta.getMappings();
        if (mappings == null || mappings.isEmpty()) {
            throw new HopException("No fields defined to load to database");
        }
        boolean firstMapping = true;
        for (OraBulkLoaderMappingMeta mapping : mappings) {
            if (!firstMapping) {
                contents.append(", ").append(Const.CR);
            }
            firstMapping = false;
            contents.append(dm.quoteField(mapping.getFieldTable()));
            int pos = rowMeta.indexOfValue(mapping.getFieldStream());
            if (pos < 0) {
                throw new HopException("Could not find field " + mapping.getFieldStream() + " in stream");
            }
            IValueMeta v = rowMeta.getValueMeta(pos);
            switch (v.getType()) {
                case 2: {
                    if (v.getLength() > 255) {
                        contents.append(" CHAR(").append(v.getLength()).append(")");
                        break;
                    }
                    contents.append(" CHAR");
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    break;
                }
                case 3: {
                    if ("DATE".equals(mapping.getDateMask())) {
                        contents.append(" DATE 'yyyy-mm-dd'");
                        break;
                    }
                    if ("DATETIME".equals(mapping.getDateMask())) {
                        contents.append(" TIMESTAMP 'yyyy-mm-dd hh24:mi:ss.ff'");
                        break;
                    }
                    contents.append(" DATE 'yyyy-mm-dd'");
                    break;
                }
                case 8: {
                    contents.append(" ENCLOSED BY '<startlob>' AND '<endlob>'");
                    break;
                }
                case 9: {
                    contents.append(" TIMESTAMP 'yyyy-mm-dd hh24:mi:ss.ff'");
                    break;
                }
            }
        }
        contents.append(")");
        return contents.toString();
    }

    public void createControlFile(String filename, Object[] row, OraBulkLoaderMeta meta) throws HopException {
        OutputStreamWriter fw = null;
        try {
            File controlFile = new File(this.getFileObject(filename, this.variables).getURL().getFile());
            controlFile.getParentFile().mkdirs();
            controlFile.createNewFile();
            fw = new FileWriter(controlFile);
            fw.write(this.getControlFileContents(meta, this.getInputRowMeta(), row));
        }
        catch (IOException ex) {
            throw new HopException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String createCommandLine(OraBulkLoaderMeta meta, boolean password) throws HopException {
        String connectURL;
        String pass;
        String user;
        DatabaseMeta db;
        FileObject fileObject;
        StringBuilder sb = new StringBuilder(300);
        if (meta.getSqlldr() != null) {
            try {
                fileObject = this.getFileObject(meta.getSqlldr(), this.variables);
                String sqlldr = this.getFilename(fileObject);
                sb.append(sqlldr);
            }
            catch (HopFileException ex) {
                throw new HopException("Error retrieving sqlldr string", (Throwable)ex);
            }
        } else {
            throw new HopException("No sqlldr application specified");
        }
        if (meta.getControlFile() != null) {
            try {
                fileObject = this.getFileObject(meta.getControlFile(), this.variables);
                sb.append(" control='");
                sb.append(this.getFilename(fileObject));
                sb.append("'");
            }
            catch (HopFileException ex) {
                throw new HopException("Error retrieving controlfile string", (Throwable)ex);
            }
        } else {
            throw new HopException("No control file specified");
        }
        if ("AUTO_CONCURRENT".equals(meta.getLoadMethod())) {
            sb.append(" data='-'");
        }
        if (meta.getLogFile() != null) {
            try {
                fileObject = this.getFileObject(meta.getLogFile(), this.variables);
                sb.append(" log='");
                sb.append(this.getFilename(fileObject));
                sb.append("'");
            }
            catch (HopFileException ex) {
                throw new HopException("Error retrieving logfile string", (Throwable)ex);
            }
        }
        if (meta.getBadFile() != null) {
            try {
                fileObject = this.getFileObject(meta.getBadFile(), this.variables);
                sb.append(" bad='");
                sb.append(this.getFilename(fileObject));
                sb.append("'");
            }
            catch (HopFileException ex) {
                throw new HopException("Error retrieving badfile string", (Throwable)ex);
            }
        }
        if (meta.getDiscardFile() != null) {
            try {
                fileObject = this.getFileObject(meta.getDiscardFile(), this.variables);
                sb.append(" discard='");
                sb.append(this.getFilename(fileObject));
                sb.append("'");
            }
            catch (HopFileException ex) {
                throw new HopException("Error retrieving discardfile string", (Throwable)ex);
            }
        }
        if ((db = this.getPipelineMeta().findDatabase(meta.getConnection(), this.variables)) != null) {
            user = Const.NVL((String)db.getUsername(), (String)"");
            pass = Const.NVL((String)Encr.decryptPasswordOptionallyEncrypted((String)this.resolve(db.getPassword())), (String)"");
            if (!password) {
                pass = "******";
            }
            if ((connectURL = Const.NVL((String)db.getURL(this.variables), (String)"")).indexOf(64) >= 0) {
                connectURL = connectURL.substring(connectURL.indexOf(64) + 1);
            }
        } else {
            throw new HopException("No connection specified");
        }
        sb.append(" userid='").append(this.resolve(user)).append("/").append(this.resolve(pass)).append("@").append(this.resolve(connectURL)).append("'");
        if (meta.isDirectPath()) {
            sb.append(" DIRECT=TRUE");
            if (this.getTransformMeta().getCopies(this.variables) > 1 || meta.isParallel()) {
                sb.append(" PARALLEL=TRUE");
            }
        }
        return sb.toString();
    }

    public void checkExitVal(int exitVal) throws HopException {
        if (exitVal == 0) {
            return;
        }
        if (((OraBulkLoaderMeta)this.meta).isFailOnWarning() && exitVal == 2) {
            throw new HopException("sqlldr returned warning");
        }
        if (((OraBulkLoaderMeta)this.meta).isFailOnError() && exitVal != 2) {
            throw new HopException("sqlldr returned an error (exit code " + exitVal + ")");
        }
    }

    public boolean execute(OraBulkLoaderMeta meta, boolean wait) throws HopException {
        Runtime runtime = Runtime.getRuntime();
        try {
            this.sqlldrProcess = runtime.exec(this.createCommandLine(meta, true));
            StreamLogger errorLogger = new StreamLogger(this.sqlldrProcess.getErrorStream(), "ERROR");
            StreamLogger outputLogger = new StreamLogger(this.sqlldrProcess.getInputStream(), "OUTPUT");
            errorLogger.start();
            outputLogger.start();
            if (wait) {
                int exitVal = this.sqlldrProcess.waitFor();
                this.sqlldrProcess = null;
                this.logBasic(BaseMessages.getString(PKG, (String)CONST_ORA_BULK_LOADER_LOG_EXIT_VALUE_SQLLDR, (String[])new String[]{"" + exitVal}));
                this.checkExitVal(exitVal);
            }
        }
        catch (Exception ex) {
            throw new HopException("Error while executing sqlldr '" + this.createCommandLine(meta, false) + "'");
        }
        return true;
    }

    public boolean processRow() throws HopException {
        try {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                if (!this.preview) {
                    String loadMethod;
                    if (this.output != null) {
                        try {
                            this.output.close();
                        }
                        catch (IOException e) {
                            throw new HopException("Error while closing output", (Throwable)e);
                        }
                        this.output = null;
                    }
                    if ("AUTO_END".equals(loadMethod = ((OraBulkLoaderMeta)this.meta).getLoadMethod())) {
                        if (!this.first) {
                            this.execute((OraBulkLoaderMeta)this.meta, true);
                            this.sqlldrProcess = null;
                        }
                    } else if ("AUTO_CONCURRENT".equals(((OraBulkLoaderMeta)this.meta).getLoadMethod())) {
                        try {
                            if (this.sqlldrProcess != null) {
                                int exitVal = this.sqlldrProcess.waitFor();
                                this.sqlldrProcess = null;
                                this.logBasic(BaseMessages.getString(PKG, (String)CONST_ORA_BULK_LOADER_LOG_EXIT_VALUE_SQLLDR, (String[])new String[]{"" + exitVal}));
                                this.checkExitVal(exitVal);
                            } else if (!this.first) {
                                throw new HopException("Internal error: no sqlldr process running");
                            }
                        }
                        catch (Exception ex) {
                            throw new HopException("Error while executing sqlldr", (Throwable)ex);
                        }
                    }
                }
                return false;
            }
            if (!this.preview) {
                if (this.first) {
                    this.first = false;
                    String recTerm = Const.CR;
                    if (!Utils.isEmpty((CharSequence)((OraBulkLoaderMeta)this.meta).getAltRecordTerm())) {
                        recTerm = this.substituteRecordTerminator(((OraBulkLoaderMeta)this.meta).getAltRecordTerm());
                    }
                    this.createControlFile(this.resolve(((OraBulkLoaderMeta)this.meta).getControlFile()), r, (OraBulkLoaderMeta)this.meta);
                    this.output = new OraBulkDataOutput((OraBulkLoaderMeta)this.meta, recTerm);
                    if ("AUTO_CONCURRENT".equals(((OraBulkLoaderMeta)this.meta).getLoadMethod())) {
                        this.execute((OraBulkLoaderMeta)this.meta, false);
                    }
                    this.output.open((IVariables)this, this.sqlldrProcess);
                }
                this.output.writeLine(this.getInputRowMeta(), r);
            }
            this.putRow(this.getInputRowMeta(), r);
            this.incrementLinesOutput();
        }
        catch (HopException e) {
            this.logError(BaseMessages.getString(PKG, (String)"OraBulkLoader.Log.ErrorInTransform", (String[])new String[0]) + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    protected void verifyDatabaseConnection() throws HopException {
        if (((OraBulkLoaderMeta)this.meta).getConnection() == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.GetSQL.NoConnectionDefined", (String[])new String[0]));
        }
        DatabaseMeta dm = this.getPipelineMeta().findDatabase(((OraBulkLoaderMeta)this.meta).getConnection(), this.variables);
        if (dm == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"OraBulkLoaderMeta.GetSQL.NoConnectionDefined", (String[])new String[0]));
        }
    }

    public boolean init() {
        IPipelineEngine pipeline = this.getPipeline();
        this.preview = pipeline.isPreview();
        if (super.init()) {
            try {
                this.verifyDatabaseConnection();
            }
            catch (HopException ex) {
                this.logError(ex.getMessage());
                return false;
            }
            return true;
        }
        return false;
    }

    public void dispose() {
        block14: {
            super.dispose();
            if (this.output != null) {
                try {
                    this.output.close();
                }
                catch (IOException e) {
                    this.logError("Error while closing output", e);
                }
                this.output = null;
            }
            if (this.sqlldrProcess != null) {
                try {
                    int exitVal = this.sqlldrProcess.waitFor();
                    this.sqlldrProcess = null;
                    this.logBasic(BaseMessages.getString(PKG, (String)CONST_ORA_BULK_LOADER_LOG_EXIT_VALUE_SQLLDR, (String[])new String[]{"" + exitVal}));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    if (this.sqlldrProcess == null) break block14;
                    this.sqlldrProcess.destroy();
                }
            }
        }
        if (!this.preview && ((OraBulkLoaderMeta)this.meta).isEraseFiles()) {
            FileObject fileObject = null;
            String method = ((OraBulkLoaderMeta)this.meta).getLoadMethod();
            if ("AUTO_END".equals(method) && ((OraBulkLoaderMeta)this.meta).getControlFile() != null) {
                try {
                    fileObject = this.getFileObject(((OraBulkLoaderMeta)this.meta).getControlFile(), this.variables);
                    fileObject.delete();
                    fileObject.close();
                }
                catch (Exception ex) {
                    this.logError("Error deleting control file '" + this.getFilename(fileObject) + "': " + ex.getMessage(), ex);
                }
            }
            if ("AUTO_END".equals(method) && ((OraBulkLoaderMeta)this.meta).getDataFile() != null) {
                try {
                    fileObject = this.getFileObject(((OraBulkLoaderMeta)this.meta).getDataFile(), this.variables);
                    fileObject.delete();
                    fileObject.close();
                }
                catch (Exception ex) {
                    this.logError("Error deleting data file '" + this.getFilename(fileObject) + "': " + ex.getMessage(), ex);
                }
            }
            if ("MANUAL".equals(method)) {
                this.logBasic("Deletion of files is not compatible with 'manual load method'");
            }
        }
    }

    @VisibleForTesting
    String getFilename(FileObject fileObject) {
        return HopVfs.getFilename((FileObject)fileObject);
    }

    @VisibleForTesting
    FileObject getFileObject(String fileName, IVariables variables) throws HopFileException {
        return HopVfs.getFileObject((String)variables.resolve(fileName), (IVariables)variables);
    }

    private final class StreamLogger
    extends Thread {
        private InputStream input;
        private String type;

        StreamLogger(InputStream is, String type) {
            this.input = is;
            this.type = type + ">";
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.input));
                while ((line = br.readLine()) != null) {
                    if (!OraBulkLoader.this.isBasic()) continue;
                    OraBulkLoader.this.logBasic(this.type + line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

