/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NLSExchangeAttrReply;
import com.ibm.as400.access.NLSExchangeAttrRequest;
import com.ibm.as400.access.NLSGetDoubleByteTableRequest;
import com.ibm.as400.access.NLSGetMixedByteTableRequest;
import com.ibm.as400.access.NLSGetTableReply;
import com.ibm.as400.access.NLSGetTableRequest;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.UnknownHostException;

public class NLSTableDownload {
    private static final String copyright = "Copyright (C) 1997-2016 International Business Machines Corporation and others.";
    private AS400Server server_;
    private AS400ImplRemote sys_;
    boolean checkRetry = false;
    public static final int SINGLE_BYTE_FROM_CCSID = 1;
    public static final int DOUBLE_BYTE_FROM_CCSID = 2;
    public static final int MIXED_BYTE_FROM_CCSID = 3;

    public NLSTableDownload(AS400ImplRemote system) {
        this.setSystem(system);
        String retryProperty = System.getProperty("retry");
        if (retryProperty != null) {
            this.checkRetry = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws ServerStartupException, UnknownHostException, AS400SecurityException, ConnectionDroppedException, InterruptedException, IOException {
        if (this.server_ == null) {
            AS400Server aS400Server = this.server_ = this.sys_.getConnection(6, false, false);
            synchronized (aS400Server) {
                DataStream baseReply = this.server_.getExchangeAttrReply();
                if (baseReply == null) {
                    try {
                        NLSExchangeAttrRequest exchangeAttrRequest;
                        try {
                            exchangeAttrRequest = new NLSExchangeAttrRequest(true);
                        }
                        catch (NoSuchMethodError e) {
                            exchangeAttrRequest = new NLSExchangeAttrRequest();
                        }
                        baseReply = this.server_.sendExchangeAttrRequest(exchangeAttrRequest);
                    }
                    catch (IOException e) {
                        Trace.log(2, "IOException After Exchange Attribute Request");
                        this.disconnect();
                        throw e;
                    }
                    if (baseReply instanceof NLSExchangeAttrReply) {
                        NLSExchangeAttrReply NLSReply = (NLSExchangeAttrReply)baseReply;
                        if (NLSReply.primaryRC_ != 0) {
                            Trace.log(4, "Exchange attribute failed, primary return code =", NLSReply.primaryRC_);
                            Trace.log(2, "Exchange attribute failed, secondary return code =", NLSReply.getSecondaryRC_());
                            this.disconnect();
                            throw new IOException();
                        }
                    } else {
                        Trace.log(2, "Unknown instance returned from Exchange Attribute Reply");
                        throw new InternalErrorException(2);
                    }
                }
            }
        }
    }

    public void disconnect() {
        if (this.server_ != null) {
            try {
                this.getSystem().disconnectServer(this.server_);
                this.server_ = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public char[] download(int fromCCSID, int toCCSID, boolean doubleByteFrom) throws ConnectionDroppedException, IOException, InterruptedException {
        if (doubleByteFrom) {
            return this.download(fromCCSID, toCCSID, 2);
        }
        return this.download(fromCCSID, toCCSID, 1);
    }

    public char[] download(int fromCCSID, int toCCSID, int fromType) throws ConnectionDroppedException, IOException, InterruptedException {
        NLSGetTableReply NLSReply = null;
        NLSGetTableRequest reqDs = null;
        BufferedReader reader = null;
        boolean retry = true;
        while (retry) {
            retry = false;
            if (fromType == 2) {
                reqDs = new NLSGetDoubleByteTableRequest(fromCCSID);
            } else if (fromType == 1) {
                reqDs = new NLSGetTableRequest();
            } else if (fromType == 3) {
                reqDs = new NLSGetMixedByteTableRequest(fromCCSID, toCCSID);
            } else {
                throw new IOException("Invalid fromType=" + fromType);
            }
            reqDs.setCCSIDs(fromCCSID, toCCSID);
            DataStream repDs = this.server_.sendAndReceive(reqDs);
            if (repDs instanceof NLSGetTableReply) {
                NLSReply = (NLSGetTableReply)repDs;
                if (NLSReply.primaryRC_ == 0) continue;
                System.out.println("fromCCSID=" + fromCCSID + " toCCSID=" + toCCSID + " fromType=" + fromType);
                System.out.println("ERROR:  Exchange attribute failed, primary return code =" + NLSReply.primaryRC_);
                System.out.println("ERROR:    Exchange attribute failed, secondary return code =" + NLSReply.secondaryRC_);
                Trace.log(4, "Exchange attribute failed, primary return code =", NLSReply.primaryRC_);
                Trace.log(2, "Exchange attribute failed, secondary return code =", NLSReply.secondaryRC_);
                if (this.checkRetry) {
                    String line;
                    System.out.println("Enter Y to retry");
                    if (reader == null) {
                        reader = new BufferedReader(new InputStreamReader(System.in));
                    }
                    if ((line = reader.readLine()) != null && line.length() > 0 && line.charAt(0) == 'Y') {
                        retry = true;
                        System.out.println("Retrying");
                    }
                }
                if (retry) continue;
                throw new IOException();
            }
            this.disconnect();
            Trace.log(2, "Unknown instance returned from Exchange Attribute Reply");
            throw new InternalErrorException(2);
        }
        this.disconnect();
        if (NLSReply != null) {
            return NLSReply.table_;
        }
        return null;
    }

    AS400ImplRemote getSystem() {
        return this.sys_;
    }

    void setSystem(AS400ImplRemote system) {
        if (system == null) {
            throw new NullPointerException();
        }
        this.sys_ = system;
    }

    static {
        AS400Server.addReplyStream((DataStream)new NLSExchangeAttrReply(), "as-central");
        AS400Server.addReplyStream((DataStream)new NLSGetTableReply(), "as-central");
    }
}

