/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.JDLobLocator;
import com.ibm.as400.access.JDTrace;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

class AS400JDBCInputStream
extends InputStream {
    static final String copyright = "Copyright (C) 1997-2010 International Business Machines Corporation and others.";
    private boolean closed_;
    private JDLobLocator locator_;
    private long offset_;
    private long length_;
    private long mark_ = 0L;

    AS400JDBCInputStream(JDLobLocator locator) {
        this.locator_ = locator;
        this.offset_ = 0L;
        this.closed_ = false;
        try {
            this.length_ = locator.getLength();
        }
        catch (SQLException e) {
            this.length_ = 0L;
            this.closed_ = true;
        }
    }

    AS400JDBCInputStream(JDLobLocator locator, long pos, long length) {
        long actualLen;
        this.locator_ = locator;
        this.offset_ = pos;
        this.length_ = length;
        this.closed_ = false;
        try {
            actualLen = locator.getLength();
        }
        catch (SQLException e) {
            actualLen = 0L;
            this.closed_ = true;
        }
        if (this.length_ > actualLen) {
            this.length_ = actualLen;
        }
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        long returnValue = 0L;
        returnValue = this.length_ - this.offset_;
        if (returnValue < 0L) {
            returnValue = 0L;
        }
        if (returnValue > Integer.MAX_VALUE) {
            returnValue = Integer.MAX_VALUE;
        }
        return (int)returnValue;
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed_ = true;
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.mark_ = this.offset_;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized int read() throws IOException {
        int returnValue = -1;
        byte[] data = new byte[1];
        if (this.read(data, 0, 1) > 0) {
            returnValue = data[0] & 0xFF;
        }
        return returnValue;
    }

    @Override
    public synchronized int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    @Override
    public synchronized int read(byte[] data, int start, int length) throws IOException {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        if (start < 0 || start > data.length) {
            throw new ExtendedIllegalArgumentException("start", 2);
        }
        if (length < 0 || start + length > data.length) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        if (length == 0) {
            return 0;
        }
        try {
            DBLobData lobData;
            int lengthRead;
            if (this.offset_ >= this.length_) {
                return -1;
            }
            if (this.locator_.isGraphic()) {
                length /= 2;
            }
            if ((lengthRead = (lobData = this.locator_.retrieveData(this.offset_, length)).getLength()) == 0) {
                this.closed_ = true;
                return -1;
            }
            System.arraycopy(lobData.getRawBytes(), lobData.getOffset(), data, start, lengthRead);
            this.offset_ += this.locator_.isGraphic() ? (long)(lengthRead / 2) : (long)lengthRead;
            return lengthRead;
        }
        catch (SQLException e) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Error in read" + e.getMessage());
                this.closed_ = true;
            }
            throw new IOException(e);
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.offset_ = this.mark_;
    }

    @Override
    public synchronized long skip(long length) throws IOException {
        if (this.closed_) {
            throw new ExtendedIOException(12);
        }
        if (length < 0L) {
            throw new ExtendedIllegalArgumentException("length", 2);
        }
        if (length == 0L) {
            return 0L;
        }
        long newOffset = length + this.offset_;
        long len = this.length_;
        if (newOffset > len) {
            length = len - this.offset_;
            this.offset_ = len;
        } else {
            this.offset_ += length;
        }
        return length;
    }
}

