/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery.providers;

import com.google.auto.service.AutoService;
import org.apache.beam.model.pipeline.v1.ExternalTransforms;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigquery.providers.BigQueryFileLoadsSchemaTransformProvider;
import org.apache.beam.sdk.io.gcp.bigquery.providers.BigQueryStorageWriteApiSchemaTransformProvider;
import org.apache.beam.sdk.io.gcp.bigquery.providers.BigQueryWriteConfiguration;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.construction.BeamUrns;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ProtocolMessageEnum;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
@AutoService(value={SchemaTransformProvider.class})
public class BigQueryWriteSchemaTransformProvider
extends TypedSchemaTransformProvider<BigQueryWriteConfiguration> {
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return BeamUrns.getUrn((ProtocolMessageEnum)ExternalTransforms.ManagedTransforms.Urns.BIGQUERY_WRITE);
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized BigQueryWriteConfiguration configuration) {
        return new BigQueryWriteSchemaTransform(configuration);
    }

    public static class BigQueryWriteSchemaTransform
    extends SchemaTransform {
        private final @UnknownKeyFor @NonNull @Initialized BigQueryWriteConfiguration configuration;

        BigQueryWriteSchemaTransform(@UnknownKeyFor @NonNull @Initialized BigQueryWriteConfiguration configuration) {
            configuration.validate();
            this.configuration = configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            if (input.getSinglePCollection().isBounded().equals((Object)PCollection.IsBounded.BOUNDED)) {
                return (PCollectionRowTuple)input.apply((PTransform)new BigQueryFileLoadsSchemaTransformProvider().from(this.configuration));
            }
            return (PCollectionRowTuple)input.apply((PTransform)new BigQueryStorageWriteApiSchemaTransformProvider().from(this.configuration));
        }

        public @UnknownKeyFor @NonNull @Initialized Row getConfigurationRow() {
            try {
                return ((Row)SchemaRegistry.createDefault().getToRowFunction(BigQueryWriteConfiguration.class).apply((Object)this.configuration)).sorted().toSnakeCase();
            }
            catch (NoSuchSchemaException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

