/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import io.github.spannm.jackcess.Cursor;
import io.github.spannm.jackcess.Table;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import net.ucanaccess.commands.AbstractCursorCommand;
import net.ucanaccess.commands.CompositeFeedbackAction;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.commands.IndexSelector;
import net.ucanaccess.commands.InsertCommand;
import net.ucanaccess.converters.Persist2Jet;
import net.ucanaccess.exception.UcanaccessSQLException;
import net.ucanaccess.util.Try;

public class DeleteCommand
extends AbstractCursorCommand {
    private final String execId;
    private final IndexSelector indexSelector;
    private final Map<String, Object> rowPattern;
    private final Table table;

    public DeleteCommand(Table _table, Map<String, Object> _rowPattern, String _execId) {
        this.indexSelector = new IndexSelector(_table);
        this.rowPattern = _rowPattern;
        this.execId = _execId;
        this.table = _table;
    }

    @Override
    public String getExecId() {
        return this.execId;
    }

    @Override
    public IndexSelector getIndexSelector() {
        return this.indexSelector;
    }

    @Override
    public Map<String, Object> getRowPattern() {
        return this.rowPattern;
    }

    @Override
    public String getTableName() {
        return this.table.getName();
    }

    @Override
    public ICommand.CommandType getType() {
        return ICommand.CommandType.DELETE;
    }

    @Override
    public IFeedbackAction persist() throws SQLException {
        Try.catching(() -> {
            Cursor cur = this.indexSelector.getCursor();
            if (cur.findNextRow(this.rowPattern)) {
                cur.deleteCurrentRow();
            }
        }).orThrow(UcanaccessSQLException::new);
        return null;
    }

    @Override
    public CompositeFeedbackAction persistCurrentRow(Cursor cur) throws IOException {
        cur.deleteCurrentRow();
        return null;
    }

    @Override
    public IFeedbackAction rollback() throws SQLException {
        InsertCommand ic = new InsertCommand(this.table, new Persist2Jet().getValues(this.rowPattern, this.table), this.execId);
        return ic.persist();
    }
}

