/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.cluster;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.ProfilingInfo;
import org.apache.flink.runtime.rest.messages.cluster.ProfilingRequestBody;
import org.apache.flink.runtime.util.profiler.ProfilingService;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.concurrent.FutureUtils;

public class JobManagerProfilingHandler
extends AbstractRestHandler<RestfulGateway, ProfilingRequestBody, ProfilingInfo, EmptyMessageParameters> {
    private final long maxDurationInSeconds;
    private final ProfilingService profilingService;

    public JobManagerProfilingHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<ProfilingRequestBody, ProfilingInfo, EmptyMessageParameters> messageHeaders, Configuration configuration) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.maxDurationInSeconds = ((Duration)configuration.get(RestOptions.MAX_PROFILING_DURATION)).getSeconds();
        this.profilingService = ProfilingService.getInstance(configuration);
    }

    @Override
    protected CompletableFuture<ProfilingInfo> handleRequest(@Nonnull HandlerRequest<ProfilingRequestBody> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        ProfilingRequestBody profilingRequest = request.getRequestBody();
        int duration = profilingRequest.getDuration();
        if (duration <= 0 || (long)duration > this.maxDurationInSeconds) {
            return FutureUtils.completedExceptionally((Throwable)new IllegalArgumentException(String.format("`duration` must be set between (0s, %ds].", this.maxDurationInSeconds)));
        }
        return this.profilingService.requestProfiling("JobManager", duration, profilingRequest.getMode());
    }
}

