/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.execsqlrow;

import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.execsqlrow.ExecSqlRowData;
import org.apache.hop.pipeline.transforms.execsqlrow.ExecSqlRowMeta;

public class ExecSqlRow
extends BaseTransform<ExecSqlRowMeta, ExecSqlRowData> {
    private static final Class<?> PKG = ExecSqlRowMeta.class;

    public ExecSqlRow(TransformMeta transformMeta, ExecSqlRowMeta meta, ExecSqlRowData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public static final RowMetaAndData getResultRow(Result result, String upd, String ins, String del, String read) {
        ValueMetaInteger meta;
        RowMetaAndData resultRow = new RowMetaAndData();
        if (upd != null && upd.length() > 0) {
            meta = new ValueMetaInteger(upd);
            meta.setLength(10, 0);
            resultRow.addValue((IValueMeta)meta, (Object)result.getNrLinesUpdated());
        }
        if (ins != null && ins.length() > 0) {
            meta = new ValueMetaInteger(ins);
            meta.setLength(10, 0);
            resultRow.addValue((IValueMeta)meta, (Object)result.getNrLinesOutput());
        }
        if (del != null && del.length() > 0) {
            meta = new ValueMetaInteger(del);
            meta.setLength(10, 0);
            resultRow.addValue((IValueMeta)meta, (Object)result.getNrLinesDeleted());
        }
        if (read != null && read.length() > 0) {
            meta = new ValueMetaInteger(read);
            meta.setLength(10, 0);
            resultRow.addValue((IValueMeta)meta, (Object)result.getNrLinesRead());
        }
        return resultRow;
    }

    public boolean processRow() throws HopException {
        block18: {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                ((ExecSqlRowData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((ExecSqlRowMeta)this.meta).getFields(((ExecSqlRowData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                if (Utils.isEmpty((CharSequence)((ExecSqlRowMeta)this.meta).getSqlFieldName())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ExecSqlRow.Error.SQLFieldFieldMissing", (String[])new String[0]));
                }
                if (((ExecSqlRowData)this.data).indexOfSqlFieldname < 0) {
                    ((ExecSqlRowData)this.data).indexOfSqlFieldname = this.getInputRowMeta().indexOfValue(((ExecSqlRowMeta)this.meta).getSqlFieldName());
                    if (((ExecSqlRowData)this.data).indexOfSqlFieldname < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"ExecSqlRow.Exception.CouldnotFindField", (String[])new String[]{((ExecSqlRowMeta)this.meta).getSqlFieldName()}));
                    }
                }
            }
            String sql = this.getInputRowMeta().getString(row, ((ExecSqlRowData)this.data).indexOfSqlFieldname);
            try {
                if (((ExecSqlRowMeta)this.meta).isSqlFromfile()) {
                    if (Utils.isEmpty((CharSequence)sql)) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"ExecSqlRow.Log.EmptySQLFromFile", (String[])new String[0]));
                    }
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"ExecSqlRow.Log.ExecutingSQLFromFile", (String[])new String[]{sql}));
                    }
                    ((ExecSqlRowData)this.data).result = ((ExecSqlRowData)this.data).db.execStatementsFromFile(sql, ((ExecSqlRowMeta)this.meta).isSendOneStatement());
                } else {
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"ExecSqlRow.Log.ExecutingSQLScript", (String[])new String[0]) + Const.CR + sql);
                    }
                    ((ExecSqlRowData)this.data).result = ((ExecSqlRowMeta)this.meta).isSendOneStatement() ? ((ExecSqlRowData)this.data).db.execStatement(sql) : ((ExecSqlRowData)this.data).db.execStatements(sql);
                }
                RowMetaAndData add = ExecSqlRow.getResultRow(((ExecSqlRowData)this.data).result, ((ExecSqlRowMeta)this.meta).getUpdateField(), ((ExecSqlRowMeta)this.meta).getInsertField(), ((ExecSqlRowMeta)this.meta).getDeleteField(), ((ExecSqlRowMeta)this.meta).getReadField());
                row = RowDataUtil.addRowData((Object[])row, (int)this.getInputRowMeta().size(), (Object[])add.getData());
                if (((ExecSqlRowMeta)this.meta).getCommitSize() > 0 && !((ExecSqlRowData)this.data).db.isAutoCommit()) {
                    if (((ExecSqlRowMeta)this.meta).getCommitSize() == 1) {
                        ((ExecSqlRowData)this.data).db.commit();
                    } else if (this.getLinesWritten() % (long)((ExecSqlRowMeta)this.meta).getCommitSize() == 0L) {
                        ((ExecSqlRowData)this.data).db.commit();
                    }
                }
                this.putRow(((ExecSqlRowData)this.data).outputRowMeta, row);
                if (this.checkFeedback(this.getLinesWritten()) && this.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ExecSqlRow.Log.LineNumber", (String[])new String[0]) + this.getLinesWritten());
                }
            }
            catch (HopException e) {
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"ExecSqlRow.Log.ErrorInTransform", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block18;
                this.putError(this.getInputRowMeta(), row, 1L, errorMessage, null, "ExecSqlRow001");
            }
        }
        return true;
    }

    public void dispose() {
        if (this.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"ExecSqlRow.Log.FinishingReadingQuery", (String[])new String[0]));
        }
        if (((ExecSqlRowData)this.data).db != null) {
            try {
                if (!((ExecSqlRowData)this.data).db.isAutoCommit()) {
                    if (this.getErrors() == 0L) {
                        ((ExecSqlRowData)this.data).db.commit();
                    } else {
                        ((ExecSqlRowData)this.data).db.rollback();
                    }
                }
            }
            catch (HopDatabaseException e) {
                this.logError(BaseMessages.getString(PKG, (String)"Update.Log.UnableToCommitUpdateConnection", (String[])new String[0]) + String.valueOf(((ExecSqlRowData)this.data).db) + "] :" + e.toString());
                this.setErrors(1L);
            }
            finally {
                ((ExecSqlRowData)this.data).db.disconnect();
            }
        }
        super.dispose();
    }

    public void stopRunning() throws HopException {
        if (((ExecSqlRowData)this.data).db != null) {
            ((ExecSqlRowData)this.data).db.cancelQuery();
        }
    }

    public boolean init() {
        if (super.init()) {
            DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((ExecSqlRowMeta)this.meta).getConnection(), this.variables);
            if (databaseMeta == null) {
                this.logError(BaseMessages.getString(PKG, (String)"ExecSqlRow.Init.ConnectionMissing", (String[])new String[]{this.getTransformName()}));
                return false;
            }
            ((ExecSqlRowData)this.data).db = new Database((ILoggingObject)this, (IVariables)this, databaseMeta);
            try {
                ((ExecSqlRowData)this.data).db.connect();
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ExecSqlRow.Log.ConnectedToDB", (String[])new String[0]));
                }
                if (((ExecSqlRowMeta)this.meta).getCommitSize() >= 1) {
                    ((ExecSqlRowData)this.data).db.setCommit(((ExecSqlRowMeta)this.meta).getCommitSize());
                }
                return true;
            }
            catch (HopException e) {
                this.logError(BaseMessages.getString(PKG, (String)"ExecSqlRow.Log.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }
}

