/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.debug.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Condition;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.debug.action.ActionDebugLevel;
import org.apache.hop.debug.transform.TransformDebugLevel;

public class DebugLevelUtil {
    public static void storeTransformDebugLevel(Map<String, String> debugGroupAttributesMap, String transformName, TransformDebugLevel debugLevel) throws HopValueException, UnsupportedEncodingException {
        debugGroupAttributesMap.put(transformName + " : log_level", debugLevel.getLogLevel().getCode());
        debugGroupAttributesMap.put(transformName + " : start_row", Integer.toString(debugLevel.getStartRow()));
        debugGroupAttributesMap.put(transformName + " : end_row", Integer.toString(debugLevel.getEndRow()));
        String conditionXmlString = Base64.getEncoder().encodeToString(debugLevel.getCondition().getXml().getBytes(StandardCharsets.UTF_8));
        debugGroupAttributesMap.put(transformName + " : condition", conditionXmlString);
    }

    public static TransformDebugLevel getTransformDebugLevel(Map<String, String> debugGroupAttributesMap, String transformName) throws UnsupportedEncodingException, HopXmlException {
        String logLevelCode = debugGroupAttributesMap.get(transformName + " : log_level");
        String startRowString = debugGroupAttributesMap.get(transformName + " : start_row");
        String endRowString = debugGroupAttributesMap.get(transformName + " : end_row");
        String conditionString = debugGroupAttributesMap.get(transformName + " : condition");
        if (StringUtils.isEmpty((String)logLevelCode)) {
            return null;
        }
        TransformDebugLevel debugLevel = new TransformDebugLevel();
        debugLevel.setLogLevel(LogLevel.lookupCode((String)logLevelCode));
        debugLevel.setStartRow(Const.toInt((String)startRowString, (int)-1));
        debugLevel.setEndRow(Const.toInt((String)endRowString, (int)-1));
        if (StringUtils.isNotEmpty((String)conditionString)) {
            String conditionXml = new String(Base64.getDecoder().decode(conditionString), StandardCharsets.UTF_8);
            debugLevel.setCondition(new Condition(conditionXml));
        }
        return debugLevel;
    }

    public static void clearDebugLevel(Map<String, String> debugGroupAttributesMap, String transformName) {
        debugGroupAttributesMap.remove(transformName + " : log_level");
        debugGroupAttributesMap.remove(transformName + " : start_row");
        debugGroupAttributesMap.remove(transformName + " : end_row");
        debugGroupAttributesMap.remove(transformName + " : condition");
        debugGroupAttributesMap.remove(transformName + " : action_log_level");
        debugGroupAttributesMap.remove(transformName + " : action_log_result");
        debugGroupAttributesMap.remove(transformName + " : action_log_variables");
        debugGroupAttributesMap.remove(transformName + " : action_log_result_rows");
        debugGroupAttributesMap.remove(transformName + " : action_log_result_files");
    }

    public static void storeActionDebugLevel(Map<String, String> debugGroupAttributesMap, String entryName, ActionDebugLevel debugLevel) {
        debugGroupAttributesMap.put(entryName + " : action_log_level", debugLevel.getLogLevel().getCode());
        debugGroupAttributesMap.put(entryName + " : action_log_result", debugLevel.isLoggingResult() ? "Y" : "N");
        debugGroupAttributesMap.put(entryName + " : action_log_variables", debugLevel.isLoggingVariables() ? "Y" : "N");
        debugGroupAttributesMap.put(entryName + " : action_log_result_rows", debugLevel.isLoggingResultRows() ? "Y" : "N");
        debugGroupAttributesMap.put(entryName + " : action_log_result_files", debugLevel.isLoggingResultFiles() ? "Y" : "N");
    }

    public static ActionDebugLevel getActionDebugLevel(Map<String, String> debugGroupAttributesMap, String entryName) {
        String logLevelCode = debugGroupAttributesMap.get(entryName + " : action_log_level");
        boolean loggingResult = "Y".equalsIgnoreCase(debugGroupAttributesMap.get(entryName + " : action_log_result"));
        boolean loggingVariables = "Y".equalsIgnoreCase(debugGroupAttributesMap.get(entryName + " : action_log_variables"));
        boolean loggingResultRows = "Y".equalsIgnoreCase(debugGroupAttributesMap.get(entryName + " : action_log_result_rows"));
        boolean loggingResultFiles = "Y".equalsIgnoreCase(debugGroupAttributesMap.get(entryName + " : action_log_result_files"));
        if (StringUtils.isEmpty((String)logLevelCode)) {
            return null;
        }
        ActionDebugLevel debugLevel = new ActionDebugLevel();
        debugLevel.setLogLevel(LogLevel.lookupCode((String)logLevelCode));
        debugLevel.setLoggingResult(loggingResult);
        debugLevel.setLoggingVariables(loggingVariables);
        debugLevel.setLoggingResultRows(loggingResultRows);
        debugLevel.setLoggingResultFiles(loggingResultFiles);
        return debugLevel;
    }

    public static String getDurationHMS(double seconds) {
        int day = (int)TimeUnit.SECONDS.toDays((long)seconds);
        long hours = TimeUnit.SECONDS.toHours((long)seconds) - (long)(day * 24);
        long minute = TimeUnit.SECONDS.toMinutes((long)seconds) - TimeUnit.SECONDS.toHours((long)seconds) * 60L;
        long second = TimeUnit.SECONDS.toSeconds((long)seconds) - TimeUnit.SECONDS.toMinutes((long)seconds) * 60L;
        long ms = (long)((seconds - (double)((long)seconds)) * 1000.0);
        StringBuilder hms = new StringBuilder();
        if (day > 0) {
            hms.append(day + "d ");
        }
        if (day > 0 || hours > 0L) {
            hms.append(hours + "h ");
        }
        if (day > 0 || hours > 0L || minute > 0L) {
            hms.append(String.format("%2d", minute) + "' ");
        }
        hms.append(String.format("%2d", second) + ".");
        hms.append(String.format("%03d", ms) + "\"");
        return hms.toString();
    }
}

