/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mergejoin;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;
import org.apache.hop.pipeline.transforms.mergejoin.MergeJoin;
import org.apache.hop.pipeline.transforms.mergejoin.MergeJoinData;

@Transform(id="MergeJoin", image="mergejoin.svg", name="i18n::MergeJoin.Name", description="i18n::MergeJoin.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Joins", keywords={"i18n::MergeJoinMeta.keyword"}, documentationUrl="/pipeline/transforms/mergejoin.html")
public class MergeJoinMeta
extends BaseTransformMeta<MergeJoin, MergeJoinData> {
    private static final Class<?> PKG = MergeJoinMeta.class;
    public static final String[] joinTypes = new String[]{"INNER", "LEFT OUTER", "RIGHT OUTER", "FULL OUTER"};
    public static final boolean[] one_optionals = new boolean[]{false, false, true, true};
    public static final boolean[] two_optionals = new boolean[]{false, true, false, true};
    @HopMetadataProperty(key="join_type", injectionKey="JOIN_TYPE", injectionKeyDescription="MergeJoin.Injection.JOIN_TYPE")
    private String joinType;
    @HopMetadataProperty(key="transform1", injectionKey="LEFT_TRANSFORM", injectionKeyDescription="MergeJoin.Injection.LEFT_TRANSFORM")
    private String leftTransformName;
    @HopMetadataProperty(key="transform2", injectionKey="RIGHT_TRANSFORM", injectionKeyDescription="MergeJoin.Injection.RIGHT_TRANSFORM")
    private String rightTransformName;
    @HopMetadataProperty(groupKey="keys_1", key="key", injectionGroupKey="KEY_FIELDS1", injectionGroupDescription="MergeJoin.Injection.KEY_FIELDS1", injectionKey="KEY_FIELD1", injectionKeyDescription="MergeJoin.Injection.KEY_FIELD1")
    private List<String> keyFields1 = new ArrayList<String>();
    @HopMetadataProperty(groupKey="keys_2", key="key", injectionGroupKey="KEY_FIELDS2", injectionGroupDescription="MergeJoin.Injection.KEY_FIELDS2", injectionKey="KEY_FIELD2", injectionKeyDescription="MergeJoin.Injection.KEY_FIELD2")
    private List<String> keyFields2 = new ArrayList<String>();

    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    public MergeJoinMeta clone() {
        MergeJoinMeta meta = new MergeJoinMeta();
        meta.leftTransformName = this.leftTransformName;
        meta.rightTransformName = this.rightTransformName;
        meta.joinType = this.joinType;
        meta.keyFields1.addAll(this.keyFields1);
        meta.keyFields2.addAll(this.keyFields2);
        return meta;
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        List infoStreams = this.getTransformIOMeta().getInfoStreams();
        if (this.parentTransformMeta != null) {
            Object[] prev = this.parentTransformMeta.getParentPipelineMeta().getPrevTransformNames(this.parentTransformMeta);
            if (this.leftTransformName != null && !ArrayUtils.contains((Object[])prev, (Object)this.leftTransformName)) {
                this.leftTransformName = null;
                this.setChanged();
            }
            if (this.rightTransformName != null && !ArrayUtils.contains((Object[])prev, (Object)this.rightTransformName)) {
                this.rightTransformName = null;
                this.setChanged();
            }
        }
        ((IStream)infoStreams.get(0)).setTransformMeta(TransformMeta.findTransform(transforms, (String)this.leftTransformName));
        ((IStream)infoStreams.get(1)).setTransformMeta(TransformMeta.findTransform(transforms, (String)this.rightTransformName));
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"MergeJoinMeta.CheckResult.TransformNotVerified", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        int i;
        if (info != null) {
            for (i = 0; i < info.length; ++i) {
                if (info[i] == null) continue;
                r.mergeRowMeta(info[i], name);
            }
        }
        for (i = 0; i < r.size(); ++i) {
            IValueMeta vmi = r.getValueMeta(i);
            if (vmi == null || !Utils.isEmpty((CharSequence)vmi.getName())) continue;
            vmi.setOrigin(name);
        }
    }

    public ITransform getTransform(TransformMeta transformMeta, MergeJoinData data, int cnr, PipelineMeta tr, Pipeline pipeline) {
        return new MergeJoin(transformMeta, this, data, cnr, tr, pipeline);
    }

    public ITransformIOMeta getTransformIOMeta() {
        ITransformIOMeta ioMeta = super.getTransformIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new TransformIOMeta(true, true, false, false, false, false);
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"MergeJoinMeta.InfoStream.FirstStream.Description", (String[])new String[0]), StreamIcon.INFO, null));
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"MergeJoinMeta.InfoStream.SecondStream.Description", (String[])new String[0]), StreamIcon.INFO, null));
            this.setTransformIOMeta(ioMeta);
        }
        return ioMeta;
    }

    public void resetTransformIoMeta() {
    }

    public PipelineMeta.PipelineType[] getSupportedPipelineTypes() {
        return new PipelineMeta.PipelineType[]{PipelineMeta.PipelineType.Normal};
    }

    public String getJoinType() {
        return this.joinType;
    }

    public void setJoinType(String joinType) {
        this.joinType = joinType;
    }

    public String getLeftTransformName() {
        return this.leftTransformName;
    }

    public void setLeftTransformName(String leftTransformName) {
        this.leftTransformName = leftTransformName;
    }

    public String getRightTransformName() {
        return this.rightTransformName;
    }

    public void setRightTransformName(String rightTransformName) {
        this.rightTransformName = rightTransformName;
    }

    public List<String> getKeyFields1() {
        return this.keyFields1;
    }

    public void setKeyFields1(List<String> keyFields1) {
        this.keyFields1 = keyFields1;
    }

    public List<String> getKeyFields2() {
        return this.keyFields2;
    }

    public void setKeyFields2(List<String> keyFields2) {
        this.keyFields2 = keyFields2;
    }
}

