/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.metrics3.reporter.config;

import com.addthis.metrics.reporter.config.AbstractReporterConfig;
import com.addthis.metrics3.reporter.config.ConsoleReporterConfig;
import com.addthis.metrics3.reporter.config.CsvReporterConfig;
import com.addthis.metrics3.reporter.config.GangliaReporterConfig;
import com.addthis.metrics3.reporter.config.GraphiteReporterConfig;
import com.addthis.metrics3.reporter.config.InfluxDBReporterConfig;
import com.addthis.metrics3.reporter.config.MetricsReporterConfigThree;
import com.addthis.metrics3.reporter.config.PrometheusReporterConfig;
import com.addthis.metrics3.reporter.config.RiemannReporterConfig;
import com.addthis.metrics3.reporter.config.StatsDReporterConfig;
import com.addthis.metrics3.reporter.config.ZabbixReporterConfig;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReporterConfig
extends AbstractReporterConfig {
    private static final Logger log = LoggerFactory.getLogger(ReporterConfig.class);
    @Valid
    private List<ConsoleReporterConfig> console;
    @Valid
    private List<CsvReporterConfig> csv;
    @Valid
    private List<GangliaReporterConfig> ganglia;
    @Valid
    private List<GraphiteReporterConfig> graphite;
    @Valid
    private List<InfluxDBReporterConfig> influxdb;
    @Valid
    private List<RiemannReporterConfig> riemann;
    @Valid
    private List<StatsDReporterConfig> statsd;
    @Valid
    private List<ZabbixReporterConfig> zabbix;
    @Valid
    private List<PrometheusReporterConfig> prometheus;

    public List<ConsoleReporterConfig> getConsole() {
        return this.console;
    }

    public void setConsole(List<ConsoleReporterConfig> console) {
        this.console = console;
    }

    public List<CsvReporterConfig> getCsv() {
        return this.csv;
    }

    public void setCsv(List<CsvReporterConfig> csv) {
        this.csv = csv;
    }

    public List<GangliaReporterConfig> getGanglia() {
        return this.ganglia;
    }

    public void setGanglia(List<GangliaReporterConfig> ganglia) {
        this.ganglia = ganglia;
    }

    public List<GraphiteReporterConfig> getGraphite() {
        return this.graphite;
    }

    public void setGraphite(List<GraphiteReporterConfig> graphite) {
        this.graphite = graphite;
    }

    public List<InfluxDBReporterConfig> getInfluxdb() {
        return this.influxdb;
    }

    public void setInfluxdb(List<InfluxDBReporterConfig> influxdb) {
        this.influxdb = influxdb;
    }

    public List<RiemannReporterConfig> getRiemann() {
        return this.riemann;
    }

    public void setRiemann(List<RiemannReporterConfig> riemann) {
        this.riemann = riemann;
    }

    public List<StatsDReporterConfig> getStatsd() {
        return this.statsd;
    }

    public void setStatsd(List<StatsDReporterConfig> statsd) {
        this.statsd = statsd;
    }

    public List<ZabbixReporterConfig> getZabbix() {
        return this.zabbix;
    }

    public void setZabbix(List<ZabbixReporterConfig> zabbix) {
        this.zabbix = zabbix;
    }

    public void setPrometheus(List<PrometheusReporterConfig> prometheus) {
        this.prometheus = prometheus;
    }

    public List<PrometheusReporterConfig> getPrometheus() {
        return this.prometheus;
    }

    public boolean enableConsole(MetricRegistry registry) {
        boolean failures = false;
        if (this.console == null) {
            log.debug("Asked to enable console, but it was not configured");
            return false;
        }
        for (ConsoleReporterConfig consoleConfig : this.console) {
            if (consoleConfig.enable(registry)) continue;
            failures = true;
        }
        return !failures;
    }

    public boolean enableCsv(MetricRegistry registry) {
        boolean failures = false;
        if (this.csv == null) {
            log.debug("Asked to enable csv, but it was not configured");
            return false;
        }
        for (CsvReporterConfig csvConfig : this.csv) {
            if (csvConfig.enable(registry)) continue;
            failures = true;
        }
        return !failures;
    }

    public boolean enableGanglia(MetricRegistry registry) {
        boolean failures = false;
        if (this.ganglia == null) {
            log.debug("Asked to enable ganglia, but it was not configured");
            return false;
        }
        for (GangliaReporterConfig gangliaConfig : this.ganglia) {
            if (gangliaConfig.enable(registry)) continue;
            failures = true;
        }
        return !failures;
    }

    public boolean enableGraphite(MetricRegistry registry) {
        boolean failures = false;
        if (this.graphite == null) {
            log.debug("Asked to enable graphite, but it was not configured");
            return false;
        }
        for (GraphiteReporterConfig graphiteConfig : this.graphite) {
            if (graphiteConfig.enable(registry)) continue;
            failures = true;
        }
        return !failures;
    }

    public boolean enablePrometheus(MetricRegistry registry) {
        boolean failures = false;
        if (this.prometheus == null) {
            log.debug("Asked to enable prometheus, but it was not configured");
            return false;
        }
        for (PrometheusReporterConfig prometheusConfig : this.prometheus) {
            if (prometheusConfig.enable(registry)) continue;
            failures = true;
        }
        return !failures;
    }

    public boolean enableInfluxdb(MetricRegistry registry) {
        boolean failures = false;
        if (this.influxdb == null) {
            log.debug("Asked to enable influx, but it was not configured");
            return false;
        }
        for (InfluxDBReporterConfig influxConfig : this.influxdb) {
            if (influxConfig.enable(registry)) continue;
            failures = true;
        }
        return !failures;
    }

    public boolean enableRiemann(MetricRegistry registry) {
        boolean failures = false;
        if (this.riemann == null) {
            log.debug("Asked to enable riemann, but it was not configured");
            return false;
        }
        for (RiemannReporterConfig riemannConfig : this.riemann) {
            if (riemannConfig.enable(registry)) continue;
            failures = true;
        }
        return !failures;
    }

    public boolean enableStatsd(MetricRegistry registry) {
        boolean failures = false;
        if (this.statsd == null) {
            log.debug("Asked to enable statsd, but it was not configured");
            return false;
        }
        for (StatsDReporterConfig statsdConfig : this.statsd) {
            if (statsdConfig.enable(registry)) continue;
            failures = true;
        }
        return !failures;
    }

    public boolean enableZabbix(MetricRegistry registry) {
        boolean failures = false;
        if (this.zabbix == null) {
            log.debug("Asked to enable zabbix, but it was not configured");
            return false;
        }
        for (ZabbixReporterConfig zabbixConfig : this.zabbix) {
            if (zabbixConfig.enable(registry)) continue;
            failures = true;
        }
        return !failures;
    }

    public boolean enableAll(MetricRegistry registry) {
        boolean enabled = false;
        if (this.console != null && this.enableConsole(registry)) {
            enabled = true;
        }
        if (this.csv != null && this.enableCsv(registry)) {
            enabled = true;
        }
        if (this.ganglia != null && this.enableGanglia(registry)) {
            enabled = true;
        }
        if (this.graphite != null && this.enableGraphite(registry)) {
            enabled = true;
        }
        if (this.influxdb != null && this.enableInfluxdb(registry)) {
            enabled = true;
        }
        if (this.riemann != null && this.enableRiemann(registry)) {
            enabled = true;
        }
        if (this.statsd != null && this.enableStatsd(registry)) {
            enabled = true;
        }
        if (this.zabbix != null && this.enableZabbix(registry)) {
            enabled = true;
        }
        if (this.prometheus != null && this.enablePrometheus(registry)) {
            enabled = true;
        }
        if (!enabled) {
            log.warn("No reporters were succesfully enabled");
        }
        return enabled;
    }

    private void report(List<? extends MetricsReporterConfigThree> reporters) {
        if (reporters != null) {
            for (MetricsReporterConfigThree metricsReporterConfigThree : reporters) {
                metricsReporterConfigThree.report();
            }
        }
    }

    public void report() {
        this.report(this.console);
        this.report(this.csv);
        this.report(this.ganglia);
        this.report(this.graphite);
        this.report(this.influxdb);
        this.report(this.riemann);
        this.report(this.zabbix);
        this.report(this.prometheus);
    }

    public static ReporterConfig loadFromFileAndValidate(String fileName) throws IOException {
        ReporterConfig config = ReporterConfig.loadFromFile(fileName);
        if (ReporterConfig.validate((Object)((Object)config))) {
            return config;
        }
        throw new AbstractReporterConfig.ReporterConfigurationException("configuration failed validation");
    }

    public static ReporterConfig loadFromFile(String fileName) throws IOException {
        return (ReporterConfig)((Object)AbstractReporterConfig.loadFromFile((String)fileName, ReporterConfig.class));
    }
}

