/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.core.Utility;

public abstract class SharedAccessHeaders {
    private final boolean preserveRawValue;
    private String cacheControl;
    private String contentDisposition;
    private String contentEncoding;
    private String contentLanguage;
    private String contentType;

    public SharedAccessHeaders() {
        this(false);
    }

    public SharedAccessHeaders(boolean preserveRawValue) {
        this.preserveRawValue = preserveRawValue;
    }

    public SharedAccessHeaders(SharedAccessHeaders other) {
        Utility.assertNotNull("other", other);
        this.contentType = other.contentType;
        this.contentDisposition = other.contentDisposition;
        this.contentEncoding = other.contentEncoding;
        this.contentLanguage = other.contentLanguage;
        this.cacheControl = other.cacheControl;
        this.preserveRawValue = other.preserveRawValue;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public void setCacheControl(String cacheControl) {
        if (this.preserveRawValue) {
            try {
                this.cacheControl = Utility.safeEncode(cacheControl);
            }
            catch (StorageException e) {
                e.printStackTrace();
            }
        } else {
            this.cacheControl = cacheControl;
        }
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public void setContentDisposition(String contentDisposition) {
        if (this.preserveRawValue) {
            try {
                this.contentDisposition = Utility.safeEncode(contentDisposition);
            }
            catch (StorageException e) {
                e.printStackTrace();
            }
        } else {
            this.contentDisposition = contentDisposition;
        }
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        if (this.preserveRawValue) {
            try {
                this.contentEncoding = Utility.safeEncode(contentEncoding);
            }
            catch (StorageException e) {
                e.printStackTrace();
            }
        } else {
            this.contentEncoding = contentEncoding;
        }
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public void setContentLanguage(String contentLanguage) {
        if (this.preserveRawValue) {
            try {
                this.contentLanguage = Utility.safeEncode(contentLanguage);
            }
            catch (StorageException e) {
                e.printStackTrace();
            }
        } else {
            this.contentLanguage = contentLanguage;
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        if (this.preserveRawValue) {
            try {
                this.contentType = Utility.safeEncode(contentType);
            }
            catch (StorageException e) {
                e.printStackTrace();
            }
        } else {
            this.contentType = contentType;
        }
    }
}

