/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.connectiongroup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.Permissions;
import org.apache.guacamole.net.auth.SharingProfile;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.rest.connection.APIConnection;
import org.apache.guacamole.rest.connectiongroup.APIConnectionGroup;
import org.apache.guacamole.rest.sharingprofile.APISharingProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionGroupTree {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionGroupTree.class);
    private final APIConnectionGroup rootAPIGroup;
    private final ObjectPermissionSet connectionPermissions;
    private final ObjectPermissionSet sharingProfilePermissions;
    private final Directory<Connection> connectionDirectory;
    private final Directory<ConnectionGroup> connectionGroupDirectory;
    private final Directory<SharingProfile> sharingProfileDirectory;
    private final Map<String, APIConnectionGroup> retrievedGroups = new HashMap();
    private final Map<String, APIConnection> retrievedConnections = new HashMap();

    private void addConnections(Collection<Connection> connections) throws GuacamoleException {
        for (Connection connection : connections) {
            APIConnectionGroup parent = (APIConnectionGroup)this.retrievedGroups.get(connection.getParentIdentifier());
            if (parent != null) {
                ArrayList<APIConnection> children = parent.getChildConnections();
                if (children == null) {
                    children = new ArrayList<APIConnection>();
                    parent.setChildConnections(children);
                }
                APIConnection apiConnection = new APIConnection(connection);
                this.retrievedConnections.put(connection.getIdentifier(), apiConnection);
                children.add(apiConnection);
                continue;
            }
            logger.debug("Connection \"{}\" cannot be added to the tree: parent \"{}\" does not actually exist.", (Object)connection.getIdentifier(), (Object)connection.getParentIdentifier());
        }
    }

    private void addConnectionGroups(Collection<ConnectionGroup> connectionGroups) {
        for (ConnectionGroup connectionGroup : connectionGroups) {
            APIConnectionGroup parent = (APIConnectionGroup)this.retrievedGroups.get(connectionGroup.getParentIdentifier());
            if (parent != null) {
                ArrayList<APIConnectionGroup> children = parent.getChildConnectionGroups();
                if (children == null) {
                    children = new ArrayList<APIConnectionGroup>();
                    parent.setChildConnectionGroups(children);
                }
                APIConnectionGroup apiConnectionGroup = new APIConnectionGroup(connectionGroup);
                this.retrievedGroups.put(connectionGroup.getIdentifier(), apiConnectionGroup);
                children.add(apiConnectionGroup);
                continue;
            }
            logger.debug("Connection group \"{}\" cannot be added to the tree: parent \"{}\" does not actually exist.", (Object)connectionGroup.getIdentifier(), (Object)connectionGroup.getParentIdentifier());
        }
    }

    private void addSharingProfiles(Collection<SharingProfile> sharingProfiles) throws GuacamoleException {
        for (SharingProfile sharingProfile : sharingProfiles) {
            String primaryConnectionIdentifier = sharingProfile.getPrimaryConnectionIdentifier();
            APIConnection primaryConnection = (APIConnection)this.retrievedConnections.get(primaryConnectionIdentifier);
            if (primaryConnection != null) {
                ArrayList<APISharingProfile> children = primaryConnection.getSharingProfiles();
                if (children == null) {
                    children = new ArrayList<APISharingProfile>();
                    primaryConnection.setSharingProfiles(children);
                }
                children.add(new APISharingProfile(sharingProfile));
                continue;
            }
            logger.debug("Sharing profile \"{}\" cannot be added to the tree: primary connection \"{}\" does not actually exist.", (Object)sharingProfile.getIdentifier(), (Object)primaryConnectionIdentifier);
        }
    }

    private void addConnectionGroupDescendants(Collection<ConnectionGroup> parents, List<ObjectPermission.Type> permissions) throws GuacamoleException {
        if (parents.isEmpty()) {
            return;
        }
        Collection childConnectionIdentifiers = new ArrayList();
        ArrayList childConnectionGroupIdentifiers = new ArrayList();
        for (ConnectionGroup parent : parents) {
            childConnectionIdentifiers.addAll(parent.getConnectionIdentifiers());
            childConnectionGroupIdentifiers.addAll(parent.getConnectionGroupIdentifiers());
        }
        if (permissions != null && !permissions.isEmpty()) {
            childConnectionIdentifiers = this.connectionPermissions.getAccessibleObjects(permissions, childConnectionIdentifiers);
        }
        if (!childConnectionIdentifiers.isEmpty()) {
            Collection childConnections = this.connectionDirectory.getAll(childConnectionIdentifiers);
            this.addConnections(childConnections);
            this.addConnectionDescendants(childConnections, permissions);
        }
        if (!childConnectionGroupIdentifiers.isEmpty()) {
            Collection childConnectionGroups = this.connectionGroupDirectory.getAll(childConnectionGroupIdentifiers);
            this.addConnectionGroups(childConnectionGroups);
            this.addConnectionGroupDescendants(childConnectionGroups, permissions);
        }
    }

    private void addConnectionDescendants(Collection<Connection> connections, List<ObjectPermission.Type> permissions) throws GuacamoleException {
        if (connections.isEmpty()) {
            return;
        }
        Collection identifiers = new ArrayList();
        for (Connection connection : connections) {
            identifiers.addAll(connection.getSharingProfileIdentifiers());
        }
        if (permissions != null && !permissions.isEmpty()) {
            identifiers = this.sharingProfilePermissions.getAccessibleObjects(permissions, identifiers);
        }
        if (!identifiers.isEmpty()) {
            Collection sharingProfiles = this.sharingProfileDirectory.getAll(identifiers);
            this.addSharingProfiles(sharingProfiles);
        }
    }

    public ConnectionGroupTree(UserContext userContext, ConnectionGroup root, List<ObjectPermission.Type> permissions) throws GuacamoleException {
        this.rootAPIGroup = new APIConnectionGroup(root);
        this.retrievedGroups.put(root.getIdentifier(), this.rootAPIGroup);
        Permissions effective = userContext.self().getEffectivePermissions();
        this.connectionPermissions = effective.getConnectionPermissions();
        this.sharingProfilePermissions = effective.getSharingProfilePermissions();
        this.connectionDirectory = userContext.getConnectionDirectory();
        this.connectionGroupDirectory = userContext.getConnectionGroupDirectory();
        this.sharingProfileDirectory = userContext.getSharingProfileDirectory();
        this.addConnectionGroupDescendants(Collections.singleton(root), permissions);
    }

    public APIConnectionGroup getRootAPIConnectionGroup() {
        return this.rootAPIGroup;
    }
}

