/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.connection;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.GuacamoleUnsupportedException;
import org.apache.guacamole.net.auth.ActivityRecordSet;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.Identifiable;
import org.apache.guacamole.net.auth.Permissions;
import org.apache.guacamole.net.auth.SharingProfile;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.net.auth.permission.SystemPermission;
import org.apache.guacamole.net.auth.permission.SystemPermissionSet;
import org.apache.guacamole.net.auth.simple.SimpleActivityRecordSet;
import org.apache.guacamole.protocol.GuacamoleConfiguration;
import org.apache.guacamole.rest.connection.APIConnection;
import org.apache.guacamole.rest.directory.DirectoryObjectResource;
import org.apache.guacamole.rest.directory.DirectoryObjectTranslator;
import org.apache.guacamole.rest.directory.DirectoryResource;
import org.apache.guacamole.rest.directory.DirectoryResourceFactory;
import org.apache.guacamole.rest.directory.DirectoryView;
import org.apache.guacamole.rest.history.ConnectionHistoryResource;
import org.apache.guacamole.rest.sharingprofile.APISharingProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ConnectionResource
extends DirectoryObjectResource<Connection, APIConnection> {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionResource.class);
    @Inject
    private DirectoryResourceFactory<SharingProfile, APISharingProfile> sharingProfileDirectoryResourceFactory;

    @AssistedInject
    public ConnectionResource(@Assisted AuthenticatedUser authenticatedUser, @Assisted UserContext userContext, @Assisted Directory<Connection> directory, @Assisted Connection connection, DirectoryObjectTranslator<Connection, APIConnection> translator) {
        super(authenticatedUser, userContext, Connection.class, directory, (Identifiable)connection, translator);
    }

    @GET
    @Path(value="parameters")
    public Map<String, String> getConnectionParameters() throws GuacamoleException {
        Connection connection = (Connection)this.getInternalObject();
        Permissions effective = this.getUserContext().self().getEffectivePermissions();
        SystemPermissionSet systemPermissions = effective.getSystemPermissions();
        ObjectPermissionSet connectionPermissions = effective.getConnectionPermissions();
        String identifier = connection.getIdentifier();
        if (!systemPermissions.hasPermission(SystemPermission.Type.ADMINISTER) && !connectionPermissions.hasPermission(ObjectPermission.Type.UPDATE, identifier)) {
            throw new GuacamoleSecurityException("Permission to read connection parameters denied.");
        }
        GuacamoleConfiguration config = connection.getConfiguration();
        return config.getParameters();
    }

    @Path(value="history")
    public ConnectionHistoryResource getConnectionHistory() throws GuacamoleException {
        Connection connection = (Connection)this.getInternalObject();
        try {
            return new ConnectionHistoryResource(connection.getConnectionHistory().sort(ActivityRecordSet.SortableProperty.START_DATE, true));
        }
        catch (GuacamoleUnsupportedException e) {
            logger.debug("Call to getConnectionHistory() is unsupported, falling back to getHistory().", (Throwable)e);
            try {
                return new ConnectionHistoryResource((ActivityRecordSet)new SimpleActivityRecordSet((Collection)connection.getHistory()));
            }
            catch (GuacamoleUnsupportedException e2) {
                logger.debug("Call to getHistory() is unsupported, no connection history records will be returned.", (Throwable)e2);
                return new ConnectionHistoryResource((ActivityRecordSet)new SimpleActivityRecordSet());
            }
        }
    }

    @Path(value="sharingProfiles")
    public DirectoryResource<SharingProfile, APISharingProfile> getSharingProfileDirectoryResource() throws GuacamoleException {
        UserContext userContext = this.getUserContext();
        Connection connection = (Connection)this.getInternalObject();
        DirectoryView sharingProfiles = new DirectoryView(userContext.getSharingProfileDirectory(), connection.getSharingProfileIdentifiers());
        return this.sharingProfileDirectoryResourceFactory.create(this.getAuthenticatedUser(), userContext, (Directory)sharingProfiles);
    }
}

