/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.python.operator;

import org.apache.flink.agents.api.Event;
import org.apache.flink.agents.plan.PythonFunction;
import org.apache.flink.agents.plan.actions.Action;
import org.apache.flink.agents.runtime.operator.ActionTask;
import org.apache.flink.agents.runtime.python.event.PythonEvent;
import org.apache.flink.agents.runtime.python.operator.PythonGeneratorActionTask;
import org.apache.flink.agents.runtime.python.utils.PythonActionExecutor;
import org.apache.flink.util.Preconditions;

public class PythonActionTask
extends ActionTask {
    protected final PythonActionExecutor pythonActionExecutor;

    public PythonActionTask(Object key, Event event, Action action, PythonActionExecutor pythonActionExecutor) {
        super(key, event, action);
        Preconditions.checkState((boolean)(action.getExec() instanceof PythonFunction));
        Preconditions.checkState((boolean)(event instanceof PythonEvent), (Object)("Python action only accept python event, but got " + String.valueOf(event)));
        this.pythonActionExecutor = pythonActionExecutor;
    }

    @Override
    public ActionTask.ActionTaskResult invoke() throws Exception {
        LOG.debug("Try execute python action {} for event {} with key {}.", this.action.getName(), this.event, this.key);
        this.runnerContext.checkNoPendingEvents();
        String pythonGeneratorRef = this.pythonActionExecutor.executePythonFunction((PythonFunction)this.action.getExec(), (PythonEvent)this.event, this.runnerContext);
        if (pythonGeneratorRef != null) {
            PythonGeneratorActionTask tempGeneratedActionTask = new PythonGeneratorActionTask(this.key, this.event, this.action, this.pythonActionExecutor, pythonGeneratorRef);
            tempGeneratedActionTask.setRunnerContext(this.runnerContext);
            return ((ActionTask)tempGeneratedActionTask).invoke();
        }
        return new ActionTask.ActionTaskResult(true, this.runnerContext.drainEvents(this.event.getSourceTimestamp()), null);
    }
}

