/*
 * Decompiled with CFR 0.152.
 */
package io.github.ollama4j.models.request;

import io.github.ollama4j.OllamaAPI;
import io.github.ollama4j.models.request.Auth;
import java.net.URI;
import java.net.http.HttpRequest;
import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OllamaEndpointCaller {
    private static final Logger LOG = LoggerFactory.getLogger(OllamaAPI.class);
    private final String host;
    private final Auth auth;
    private final long requestTimeoutSeconds;
    private final boolean verbose;

    public OllamaEndpointCaller(String host, Auth auth, long requestTimeoutSeconds, boolean verbose) {
        this.host = host;
        this.auth = auth;
        this.requestTimeoutSeconds = requestTimeoutSeconds;
        this.verbose = verbose;
    }

    protected abstract String getEndpointSuffix();

    protected abstract boolean parseResponseAndAddToBuffer(String var1, StringBuilder var2, StringBuilder var3);

    protected HttpRequest.Builder getRequestBuilderDefault(URI uri) {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(uri).header("Content-Type", "application/json").timeout(Duration.ofSeconds(this.requestTimeoutSeconds));
        if (this.isAuthCredentialsSet()) {
            requestBuilder.header("Authorization", this.auth.getAuthHeaderValue());
        }
        return requestBuilder;
    }

    protected boolean isAuthCredentialsSet() {
        return this.auth != null;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public Auth getAuth() {
        return this.auth;
    }

    @Generated
    public long getRequestTimeoutSeconds() {
        return this.requestTimeoutSeconds;
    }

    @Generated
    public boolean isVerbose() {
        return this.verbose;
    }
}

