/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.util;

import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.execution.HealthCheckSelector;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckFilter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String HC_FILTER_OBJECT_CLASS = "(|(objectClass=" + HealthCheck.class.getName() + ")(objectClass=org.apache.sling.hc.api.HealthCheck))";
    public static final String OMIT_PREFIX = "-";
    private final BundleContext bundleContext;

    public HealthCheckFilter(BundleContext bc) {
        this.bundleContext = bc;
    }

    public ServiceReference<HealthCheck>[] getHealthCheckServiceReferences(HealthCheckSelector selector) {
        return this.getHealthCheckServiceReferences(selector, false);
    }

    public ServiceReference<HealthCheck>[] getHealthCheckServiceReferences(HealthCheckSelector selector, boolean combineTagsWithOr) {
        CharSequence filterBuilder = selector != null ? this.getServiceFilter(selector, combineTagsWithOr) : this.getServiceFilter(HealthCheckSelector.empty(), combineTagsWithOr);
        this.log.trace("OSGi service filter in getHealthCheckServiceReferences(): {}", (Object)filterBuilder);
        try {
            String filterString = filterBuilder.length() == 0 ? null : filterBuilder.toString();
            this.bundleContext.createFilter(filterString);
            ServiceReference[] refs = this.bundleContext.getServiceReferences((String)null, filterString);
            if (refs == null) {
                this.log.debug("Found no HealthCheck services for filter: {}", (Object)filterString);
                return new ServiceReference[0];
            }
            this.log.debug("Found {} HealthCheck services for filter: {}", (Object)refs.length, (Object)filterString);
            return refs;
        }
        catch (InvalidSyntaxException ise) {
            this.log.error("Invalid OSGi filter syntax in '" + filterBuilder + "'", (Throwable)ise);
            return new ServiceReference[0];
        }
    }

    CharSequence getServiceFilter(HealthCheckSelector selector, boolean combineTagsWithOr) {
        StringBuilder filterBuilder = new StringBuilder();
        filterBuilder.append("(&");
        filterBuilder.append(HC_FILTER_OBJECT_CLASS);
        int prefixLen = OMIT_PREFIX.length();
        StringBuilder filterBuilderForOrOperator = new StringBuilder();
        StringBuilder tagsBuilder = new StringBuilder();
        int tagsAndClauses = 0;
        if (selector.tags() != null) {
            for (String tag : selector.tags()) {
                if ((tag = tag.trim()).length() == 0) continue;
                if (tag.startsWith(OMIT_PREFIX)) {
                    filterBuilder.append("(!(").append("hc.tags").append("=").append(tag.substring(prefixLen)).append("))");
                    continue;
                }
                if (combineTagsWithOr) {
                    filterBuilderForOrOperator.append("(").append("hc.tags").append("=").append(tag).append(")");
                    continue;
                }
                tagsBuilder.append("(").append("hc.tags").append("=").append(tag).append(")");
                ++tagsAndClauses;
            }
        }
        boolean addedNameToOrBuilder = false;
        if (selector.names() != null) {
            for (String name : selector.names()) {
                if ((name = name.trim()).length() == 0) continue;
                if (name.startsWith(OMIT_PREFIX)) {
                    filterBuilder.append("(!(").append("hc.name").append("=").append(this.escapeOsgiFilterLiteral(name.substring(prefixLen))).append("))");
                    continue;
                }
                filterBuilderForOrOperator.append("(").append("hc.name").append("=").append(this.escapeOsgiFilterLiteral(name)).append(")");
                addedNameToOrBuilder = true;
            }
        }
        if (addedNameToOrBuilder) {
            if (tagsAndClauses > 1) {
                filterBuilderForOrOperator.append("(&").append((CharSequence)tagsBuilder).append(")");
            } else {
                filterBuilderForOrOperator.append((CharSequence)tagsBuilder);
            }
        } else {
            filterBuilder.append((CharSequence)tagsBuilder);
        }
        if (filterBuilderForOrOperator.length() > 0) {
            filterBuilder.append("(|").append((CharSequence)filterBuilderForOrOperator).append(")");
        }
        filterBuilder.append(")");
        return filterBuilder;
    }

    private Object escapeOsgiFilterLiteral(String name) {
        return name.replace("*", "\\*").replace("(", "\\(").replace(")", "\\)");
    }
}

