/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.scheduling.cron.embedded;

import java.util.concurrent.TimeUnit;
import org.apache.felix.hc.core.impl.executor.HealthCheckExecutorThreadPool;
import org.apache.felix.hc.core.impl.scheduling.cron.embedded.EmbeddedCronScheduler;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Designate(ocd=Configuration.class)
@Component(service={EmbeddedCronSchedulerProvider.class})
public class EmbeddedCronSchedulerProvider {
    public static final String HC_SCHEDULER_NAME = "felix.hc.embedded.scheduler";
    @Reference
    private HealthCheckExecutorThreadPool threadPool;
    private Configuration configuration;
    private EmbeddedCronScheduler scheduler = null;

    @Activate
    void activate(Configuration configuration) {
        this.configuration = configuration;
    }

    public synchronized EmbeddedCronScheduler getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = new EmbeddedCronScheduler(this.threadPool.getExecutor(), this.configuration.initialDelay(), this.configuration.checkInterval(), this.configuration.timeUnit(), this.configuration.schedulerName());
        }
        return this.scheduler;
    }

    @ObjectClassDefinition(name="Health Check: Embedded Cron Scheduler")
    static @interface Configuration {
        @AttributeDefinition(name="Initial Delay", description="The initial delay before tasks are scheduled")
        public long initialDelay() default 3L;

        @AttributeDefinition(name="Check Interval Delay", description="The delay to check for a scheduled task to satisfy the cron expression")
        public long checkInterval() default 1L;

        @AttributeDefinition(name="Time unit", description="The time unit of the delays as specified in this configuration")
        public TimeUnit timeUnit() default TimeUnit.SECONDS;

        @AttributeDefinition(name="Scheduler Name", description="The embedded cron scheduler thread name")
        public String schedulerName() default "felix.hc.embedded.scheduler";
    }
}

