/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.executor;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.hc.core.impl.executor.HealthCheckExecutorThreadPoolConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={HealthCheckExecutorThreadPool.class})
@Designate(ocd=HealthCheckExecutorThreadPoolConfiguration.class)
public class HealthCheckExecutorThreadPool {
    private static final Logger LOG = LoggerFactory.getLogger(HealthCheckExecutorThreadPool.class);
    private int threadPoolSize;
    private ScheduledThreadPoolExecutor executor;

    @Activate
    protected final void activate(HealthCheckExecutorThreadPoolConfiguration configuration, BundleContext bundleContext) {
        this.threadPoolSize = configuration.threadPoolSize();
        this.executor = new ScheduledThreadPoolExecutor(this.threadPoolSize, new HcThreadFactory(), new HcRejectedExecutionHandler());
        LOG.info("Created HC Thread Pool: threadPoolSize={}", (Object)this.threadPoolSize);
    }

    @Deactivate
    protected final void deactivate() {
        this.executor.shutdown();
    }

    public void execute(Runnable job) {
        this.executor.execute(job);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable job, long intervalInSec) {
        ScheduledFuture<?> scheduleFuture = this.executor.scheduleAtFixedRate(job, 0L, intervalInSec, TimeUnit.SECONDS);
        return scheduleFuture;
    }

    public int getPoolSize() {
        return this.executor.getPoolSize();
    }

    public int getMaxCurrentlyAvailableThreads() {
        return this.threadPoolSize - this.executor.getQueue().size();
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    private final class HcRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private HcRejectedExecutionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            LOG.warn("Thread Pool {} rejected to run runnable {}", (Object)executor, (Object)r);
        }
    }

    static class HcThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        HcThreadFactory() {
            this.group = Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, "hc-thread-" + this.threadNumber.getAndIncrement());
            t.setDaemon(true);
            t.setPriority(5);
            return t;
        }
    }
}

