/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.join;

import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBJoinType;
import org.apache.empire.db.DBQuery;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.expr.compare.DBCompareAndOrExpr;
import org.apache.empire.db.expr.compare.DBCompareColExpr;
import org.apache.empire.db.expr.compare.DBCompareExpr;
import org.apache.empire.db.expr.compare.DBCompareNotExpr;
import org.apache.empire.db.expr.compare.DBCompareParenthesisExpr;
import org.apache.empire.db.expr.join.DBColumnJoinExpr;
import org.apache.empire.db.expr.join.DBJoinExpr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBCompareJoinExpr
extends DBColumnJoinExpr {
    private static final Logger log = LoggerFactory.getLogger(DBCompareJoinExpr.class);
    protected final DBCompareExpr cmp;

    private static DBColumnExpr findFirstColumn(DBCompareExpr expr) {
        if (expr instanceof DBCompareParenthesisExpr) {
            return DBCompareJoinExpr.findFirstColumn(((DBCompareParenthesisExpr)expr).unwrap());
        }
        if (expr instanceof DBCompareAndOrExpr) {
            return DBCompareJoinExpr.findFirstColumn(((DBCompareAndOrExpr)expr).getLeft());
        }
        if (expr instanceof DBCompareNotExpr) {
            return DBCompareJoinExpr.findFirstColumn(((DBCompareNotExpr)expr).getExpr());
        }
        if (expr instanceof DBCompareColExpr) {
            return ((DBCompareColExpr)expr).getColumnExpr();
        }
        log.error("Unknown class found for building a valid JOIN Expression");
        return null;
    }

    private static DBColumnExpr firstRsetColumn(DBRowSet rset) {
        if (rset instanceof DBQuery) {
            return ((DBQuery)rset).getQueryColumns()[0];
        }
        return rset.getColumn(0);
    }

    public DBCompareJoinExpr(DBRowSet rset, DBCompareExpr cmp, DBJoinType joinType) {
        super(DBCompareJoinExpr.firstRsetColumn(rset), DBCompareJoinExpr.findFirstColumn(cmp), joinType);
        this.cmp = cmp;
    }

    @Override
    public void prepareParams(DBCommand cmd, DBExpr parent) {
        this.cmp.prepareParams(cmd, this);
        super.prepareParams(cmd, this);
    }

    @Override
    public DBJoinExpr copy(DBCommand newCmd) {
        DBCompareExpr newCmp = this.cmp.copy(newCmd);
        DBCompareJoinExpr join = new DBCompareJoinExpr(this.getLeftTable(), newCmp, this.type);
        return join;
    }

    public DBCompareExpr getJoinConstraint() {
        return this.cmp;
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        if ((context & 1L) != 0L) {
            this.getLeftTable().addSQL(sql, 15L);
        }
        if ((context & 4L) != 0L) {
            switch (this.type) {
                case LEFT: {
                    sql.append(" LEFT JOIN ");
                    break;
                }
                case INNER: {
                    sql.append(" INNER JOIN ");
                    break;
                }
                case RIGHT: {
                    sql.append(" RIGHT JOIN ");
                    break;
                }
                default: {
                    sql.append(" JOIN ");
                }
            }
            this.getRightTable().addSQL(sql, 15L);
            sql.append(" ON ");
            this.cmp.addSQL(sql, 7L);
            if (this.compExpr != null) {
                sql.append(" AND ");
                this.compExpr.addSQL(sql, 7L);
            }
        }
    }
}

