/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.datasketches.common.MemorySegmentStatus;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;

interface ConcurrentSharedThetaSketch
extends MemorySegmentStatus {
    public static final long NOT_SINGLE_HASH = -1L;
    public static final double MIN_ERROR = 1.0E-7;

    public static long computeExactLimit(long k, double error) {
        return 2L * Math.min(k, (long)Math.ceil(1.0 / Math.pow(Math.max(error, 1.0E-7), 2.0)));
    }

    public long getExactLimit();

    public boolean startEagerPropagation();

    public void endPropagation(AtomicBoolean var1, boolean var2);

    public long getVolatileTheta();

    public void awaitBgPropagationTermination();

    public void initBgPropagationService();

    public boolean propagate(AtomicBoolean var1, ThetaSketch var2, long var3);

    public void propagate(long var1);

    public void updateEstimationSnapshot();

    public void updateVolatileTheta();

    public boolean validateEpoch(long var1);

    public int getCompactBytes();

    public int getCurrentBytes();

    public double getEstimate();

    public double getLowerBound(int var1);

    public double getUpperBound(int var1);

    public boolean isEmpty();

    public boolean isEstimationMode();

    public byte[] toByteArray();

    public int getRetainedEntries(boolean var1);

    public CompactThetaSketch compact();

    public CompactThetaSketch compact(boolean var1, MemorySegment var2);

    public UpdatableThetaSketch rebuild();

    public void reset();
}

