/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.runtime1.processors.Evaluatable;
import org.apache.daffodil.runtime1.processors.Processor;
import org.apache.daffodil.runtime1.processors.RuntimeData;
import org.apache.daffodil.runtime1.processors.Success$;
import org.apache.daffodil.runtime1.processors.parsers.ChoiceBranchFailed;
import org.apache.daffodil.runtime1.processors.parsers.CombinatorParser;
import org.apache.daffodil.runtime1.processors.parsers.EntireChoiceFailed;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.Parser;
import scala.Predef$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public class ChoiceParser
extends CombinatorParser {
    private final RuntimeData ctxt;
    private final Parser[] childParsers;

    public ChoiceParser(RuntimeData ctxt, Parser[] childParsers) {
        this.ctxt = ctxt;
        this.childParsers = childParsers;
        super(ctxt);
    }

    public Parser[] childParsers() {
        return this.childParsers;
    }

    @Override
    public Vector<Evaluatable<Object>> runtimeDependencies() {
        return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    @Override
    public Vector<Processor> childProcessors() {
        return Predef$.MODULE$.wrapRefArray((Object[])this.childParsers()).toVector();
    }

    @Override
    public String nom() {
        return "choice";
    }

    @Override
    public void parse(PState pstate) {
        Nil$ diagnostics = package$.MODULE$.Nil();
        int i = 0;
        int numAlternatives = this.childParsers().length;
        boolean successfullyParsedChildBranch = false;
        while (!successfullyParsedChildBranch && i < numAlternatives) {
            Parser parser = this.childParsers()[i];
            ++i;
            PState PStateUsingMacrosMixin_this = pstate;
            PState.Mark pou = PStateUsingMacrosMixin_this.createPointOfUncertainty("ChoiceParser", this.ctxt);
            try {
                parser.parse1(pstate);
                if (pstate.processorStatus() == Success$.MODULE$) {
                    successfullyParsedChildBranch = true;
                    continue;
                }
                ChoiceBranchFailed diag = new ChoiceBranchFailed(this.context().schemaFileLocation(), pstate, pstate.diagnostics());
                diagnostics = (Seq)diagnostics.$plus$colon((Object)diag);
                if (pstate.isPointOfUncertaintyResolved(pou)) {
                    i = numAlternatives;
                    continue;
                }
                pstate.resetToPointOfUncertainty(pou);
            }
            finally {
                if (PStateUsingMacrosMixin_this.isPointOfUncertaintyResolved(pou)) continue;
                PStateUsingMacrosMixin_this.discardPointOfUncertainty(pou);
            }
        }
        if (!successfullyParsedChildBranch) {
            EntireChoiceFailed allDiags = new EntireChoiceFailed(this.context().schemaFileLocation(), pstate, (Seq<Diagnostic>)((Seq)diagnostics.reverse()));
            pstate.setFailed(allDiags);
            return;
        }
    }
}

