/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.apache.daffodil.io.BoundaryMarkLimitingInputStream$;
import org.apache.daffodil.io.RegexLimitingInputStream;
import org.apache.daffodil.lib.exceptions.Assert$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class BoundaryMarkLimitingInputStream
extends InputStream {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(BoundaryMarkLimitingInputStream.class.getDeclaredField("delegateStream$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(BoundaryMarkLimitingInputStream.class.getDeclaredField("quotedBoundaryMark$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(BoundaryMarkLimitingInputStream.class.getDeclaredField("boundaryMarkIn8859$lzy1"));
    private InputStream inputStream;
    private final String boundaryMark;
    private final Charset charset;
    private final int targetChunkSize;
    private volatile Object boundaryMarkIn8859$lzy1;
    private volatile Object quotedBoundaryMark$lzy1;
    private volatile Object delegateStream$lzy1;

    public static int $lessinit$greater$default$4() {
        return BoundaryMarkLimitingInputStream$.MODULE$.$lessinit$greater$default$4();
    }

    public BoundaryMarkLimitingInputStream(InputStream inputStream, String boundaryMark, Charset charset, int targetChunkSize) {
        this.inputStream = inputStream;
        this.boundaryMark = boundaryMark;
        this.charset = charset;
        this.targetChunkSize = targetChunkSize;
        if (targetChunkSize < 1) {
            throw Assert$.MODULE$.usageError("BoundaryMarkLimitingInputStream.this.targetChunkSize.>=(1)");
        }
        if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(boundaryMark))) {
            throw Assert$.MODULE$.usageError("scala.Predef.augmentString(BoundaryMarkLimitingInputStream.this.boundaryMark).nonEmpty");
        }
    }

    private String boundaryMarkIn8859() {
        Object object = this.boundaryMarkIn8859$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.boundaryMarkIn8859$lzyINIT1();
    }

    private Object boundaryMarkIn8859$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.boundaryMarkIn8859$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = new String(this.boundaryMark.getBytes(this.charset), StandardCharsets.ISO_8859_1);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.boundaryMarkIn8859$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private String quotedBoundaryMark() {
        Object object = this.quotedBoundaryMark$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.quotedBoundaryMark$lzyINIT1();
    }

    private Object quotedBoundaryMark$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.quotedBoundaryMark$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = Pattern.quote(this.boundaryMarkIn8859());
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.quotedBoundaryMark$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private RegexLimitingInputStream delegateStream() {
        Object object = this.delegateStream$lzy1;
        if (object instanceof RegexLimitingInputStream) {
            return (RegexLimitingInputStream)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RegexLimitingInputStream)this.delegateStream$lzyINIT1();
    }

    private Object delegateStream$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.delegateStream$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RegexLimitingInputStream regexLimitingInputStream = null;
                    try {
                        regexLimitingInputStream = new RegexLimitingInputStream(this.inputStream, this.quotedBoundaryMark(), this.boundaryMarkIn8859(), this.charset, this.targetChunkSize);
                        object2 = regexLimitingInputStream == null ? LazyVals.NullValue$.MODULE$ : regexLimitingInputStream;
                        this.inputStream = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.delegateStream$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return regexLimitingInputStream;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public int read() {
        return this.delegateStream().read();
    }
}

