/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.core.grammar.primitives;

import com.ibm.icu.impl.number.PatternStringParser;
import org.apache.daffodil.core.dsom.ElementBase;
import org.apache.daffodil.core.grammar.primitives.TextNumberPatternUtils$;
import org.apache.daffodil.lib.exceptions.Assert$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.LazyInt;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public interface ConvertTextNumberMixin {
    public static void $init$(ConvertTextNumberMixin $this) {
    }

    public ElementBase e();

    public static String pattern$(ConvertTextNumberMixin $this) {
        return $this.pattern();
    }

    default public String pattern() {
        return this.e().textNumberPattern();
    }

    public int textDecimalVirtualPointFromPattern();

    public static String patternWithoutEscapedChars$(ConvertTextNumberMixin $this) {
        return $this.patternWithoutEscapedChars();
    }

    default public String patternWithoutEscapedChars() {
        Regex noEscapedTicksRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("''"));
        String patternNoEscapedTicks = noEscapedTicksRegex.replaceAllIn((CharSequence)this.pattern(), "");
        Regex noQuotedRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("'[^']+'"));
        String res = noQuotedRegex.replaceAllIn((CharSequence)patternNoEscapedTicks, "");
        return res;
    }

    public static boolean hasV$(ConvertTextNumberMixin $this) {
        return $this.hasV();
    }

    default public boolean hasV() {
        return this.patternWithoutEscapedChars().contains("V");
    }

    public static boolean hasP$(ConvertTextNumberMixin $this) {
        return $this.hasP();
    }

    default public boolean hasP() {
        return this.patternWithoutEscapedChars().contains("P");
    }

    public static int textDecimalVirtualPoint$(ConvertTextNumberMixin $this) {
        return $this.textDecimalVirtualPoint();
    }

    default public int textDecimalVirtualPoint() {
        LazyInt lazyInt = new LazyInt();
        if (this.hasV()) {
            if (this.virtualPoint$1(lazyInt) < 1) {
                throw Assert$.MODULE$.abort("Invariant broken: virtualPoint.>=(1)");
            }
            return this.virtualPoint$1(lazyInt);
        }
        if (this.hasP()) {
            if (this.virtualPoint$1(lazyInt) == 0) {
                throw Assert$.MODULE$.abort("Invariant broken: virtualPoint.!=(0)");
            }
            return this.virtualPoint$1(lazyInt);
        }
        return 0;
    }

    public static String runtimePattern$(ConvertTextNumberMixin $this) {
        return $this.runtimePattern();
    }

    default public String runtimePattern() {
        if (this.hasV() || this.hasP()) {
            String patternWithoutPV = TextNumberPatternUtils$.MODULE$.removeUnquotedPV(this.pattern());
            return patternWithoutPV;
        }
        return this.pattern();
    }

    public static PatternStringParser.ParsedPatternInfo checkPatternWithICU$(ConvertTextNumberMixin $this, ElementBase e) {
        return $this.checkPatternWithICU(e);
    }

    /*
     * WARNING - void declaration
     */
    default public PatternStringParser.ParsedPatternInfo checkPatternWithICU(ElementBase e) {
        void v0;
        try {
            void var3_3;
            String patternToCheck = this.hasV() || this.hasP() ? this.runtimePattern() : this.pattern();
            PatternStringParser.ParsedPatternInfo parsedPatternInfo = PatternStringParser.parseToPatternInfo((String)patternToCheck);
            v0 = var3_3;
        }
        catch (IllegalArgumentException ex) {
            throw this.hasV() || this.hasP() ? e.SDE(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Invalid textNumberPattern.\n              | The errors are about the pattern with the P (decimal scaling position)\n              | and V (virtual decimal point) characters removed: %s")), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ex})) : e.SDE("Invalid textNumberPattern: %s", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ex}));
        }
        return v0;
    }

    private int virtualPoint$lzyINIT1$1(LazyInt virtualPoint$lzy1$1) {
        int n;
        LazyInt lazyInt = virtualPoint$lzy1$1;
        synchronized (lazyInt) {
            n = virtualPoint$lzy1$1.initialized() ? virtualPoint$lzy1$1.value() : virtualPoint$lzy1$1.initialize(this.textDecimalVirtualPointFromPattern());
        }
        return n;
    }

    private int virtualPoint$1(LazyInt virtualPoint$lzy1$2) {
        if (virtualPoint$lzy1$2.initialized()) {
            return virtualPoint$lzy1$2.value();
        }
        return this.virtualPoint$lzyINIT1$1(virtualPoint$lzy1$2);
    }
}

