/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class SessionAddMetaDataMessageV2
extends PacketImpl {
    private String key;
    private String data;
    private boolean requiresConfirmation = true;

    public SessionAddMetaDataMessageV2() {
        super((byte)105);
    }

    protected SessionAddMetaDataMessageV2(byte packetCode) {
        super(packetCode);
    }

    public SessionAddMetaDataMessageV2(String k, String d) {
        this();
        this.key = k;
        this.data = d;
    }

    protected SessionAddMetaDataMessageV2(byte packetCode, String k, String d) {
        super(packetCode);
        this.key = k;
        this.data = d;
    }

    public SessionAddMetaDataMessageV2(String k, String d, boolean requiresConfirmation) {
        this();
        this.key = k;
        this.data = d;
        this.requiresConfirmation = requiresConfirmation;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeString(this.key);
        buffer.writeString(this.data);
        buffer.writeBoolean(this.requiresConfirmation);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.key = buffer.readString();
        this.data = buffer.readString();
        this.requiresConfirmation = buffer.readBoolean();
    }

    @Override
    public final boolean isRequiresConfirmations() {
        return this.requiresConfirmation;
    }

    public String getKey() {
        return this.key;
    }

    public String getData() {
        return this.data;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.data, this.key, this.requiresConfirmation);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", key=" + this.key);
        sb.append(", data=" + this.data);
        sb.append(", requiresConfirmation=" + this.requiresConfirmation);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionAddMetaDataMessageV2)) {
            return false;
        }
        SessionAddMetaDataMessageV2 other = (SessionAddMetaDataMessageV2)obj;
        return Objects.equals(this.data, other.data) && Objects.equals(this.key, other.key) && this.requiresConfirmation == other.requiresConfirmation;
    }
}

