/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http4;

import java.io.File;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.vfs2.AbstractProviderTestConfig;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.ProviderTestSuite;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.VfsTestUtils;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.http4.Http4FileObject;
import org.apache.commons.vfs2.provider.http4.Http4FileProvider;
import org.apache.commons.vfs2.provider.http4.Http4FileSystemConfigBuilder;
import org.apache.commons.vfs2.util.NHttpFileServer;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class Http4ProviderTestCase
extends AbstractProviderTestConfig {
    private static NHttpFileServer server;
    private static final String TEST_URI = "test.http.uri";
    private static String connectionUri;

    private static String getSystemTestUriOverride() {
        return System.getProperty(TEST_URI);
    }

    private static void setUpClass() throws Exception {
        server = NHttpFileServer.start(0, new File(VfsTestUtils.getTestDirectory()), 5000L);
        int socketPort = server.getPort();
        connectionUri = Http4ProviderTestCase.getLocalHostUriString("http4", server.getPort());
    }

    public static junit.framework.Test suite() throws Exception {
        return new ProviderTestSuite(new Http4ProviderTestCase()){

            @Override
            protected void addBaseTests() throws Exception {
                super.addBaseTests();
                this.addTests(Http4ProviderTestCase.class);
            }

            @Override
            protected void setUp() throws Exception {
                if (Http4ProviderTestCase.getSystemTestUriOverride() == null) {
                    Http4ProviderTestCase.setUpClass();
                }
                super.setUp();
            }

            @Override
            protected void tearDown() throws Exception {
                Http4ProviderTestCase.tearDownClass();
                super.tearDown();
            }
        };
    }

    private static void tearDownClass() throws InterruptedException {
        if (server != null) {
            server.shutdown(5000L, TimeUnit.SECONDS);
        }
    }

    private void checkReadTestsFolder(FileObject file) throws FileSystemException {
        Assertions.assertNotNull((Object)file.getChildren());
        Assertions.assertTrue((file.getChildren().length > 0 ? 1 : 0) != 0);
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String uri = Http4ProviderTestCase.getSystemTestUriOverride();
        if (uri == null) {
            uri = connectionUri;
        }
        return manager.resolveFile(uri);
    }

    public void ignoreTestHttp405() throws FileSystemException {
        FileObject fileObject = VFS.getManager().resolveFile("http4://www.w3schools.com/webservices/tempconvert.asmx?action=WSDL");
        Assertions.assertFalse((boolean)fileObject.getContent().isEmpty(), (String)"Content should not be empty");
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        if (!manager.hasProvider("http4")) {
            manager.addProvider("http4", (FileProvider)new Http4FileProvider());
        }
    }

    @Test
    public void testHttpTimeoutConfig() {
        FileSystemOptions opts = new FileSystemOptions();
        Http4FileSystemConfigBuilder builder = Http4FileSystemConfigBuilder.getInstance();
        Http4ProviderTestCase.assertEquals((int)0, (int)builder.getConnectionTimeout(opts));
        Http4ProviderTestCase.assertEquals((Object)Duration.ZERO, (Object)builder.getConnectionTimeoutDuration(opts));
        Http4ProviderTestCase.assertEquals((int)0, (int)builder.getSoTimeout(opts));
        Http4ProviderTestCase.assertEquals((Object)Duration.ZERO, (Object)builder.getSoTimeoutDuration(opts));
        Http4ProviderTestCase.assertEquals((String)"Jakarta-Commons-VFS", (String)builder.getUserAgent(opts));
        builder.setConnectionTimeout(opts, 60000);
        builder.setSoTimeout(opts, 60000);
        builder.setUserAgent(opts, "foo/bar");
        Http4ProviderTestCase.assertEquals((int)60000, (int)builder.getConnectionTimeout(opts));
        Http4ProviderTestCase.assertEquals((long)60000L, (long)builder.getConnectionTimeoutDuration(opts).toMillis());
        Http4ProviderTestCase.assertEquals((int)60000, (int)builder.getSoTimeout(opts));
        Http4ProviderTestCase.assertEquals((long)60000L, (long)builder.getSoTimeoutDuration(opts).toMillis());
        Http4ProviderTestCase.assertEquals((String)"foo/bar", (String)builder.getUserAgent(opts));
        builder.setConnectionTimeout(opts, Duration.ofMinutes(1L));
        builder.setSoTimeout(opts, Duration.ofMinutes(1L));
        builder.setUserAgent(opts, "foo/bar");
        Http4ProviderTestCase.assertEquals((int)60000, (int)builder.getConnectionTimeout(opts));
        Http4ProviderTestCase.assertEquals((long)60000L, (long)builder.getConnectionTimeoutDuration(opts).toMillis());
        Http4ProviderTestCase.assertEquals((int)60000, (int)builder.getSoTimeout(opts));
        Http4ProviderTestCase.assertEquals((long)60000L, (long)builder.getSoTimeoutDuration(opts).toMillis());
        Http4ProviderTestCase.assertEquals((String)"foo/bar", (String)builder.getUserAgent(opts));
    }

    private void testResolveFolderSlash(String uri, boolean followRedirect) throws FileSystemException {
        VFS.getManager().getFilesCache().close();
        FileSystemOptions opts = new FileSystemOptions();
        Http4FileSystemConfigBuilder.getInstance().setFollowRedirect(opts, followRedirect);
        FileObject file = VFS.getManager().resolveFile(uri, opts);
        try {
            this.checkReadTestsFolder(file);
        }
        catch (FileNotFolderException fileNotFolderException) {
            // empty catch block
        }
    }

    @Test
    public void testResolveFolderSlashNoRedirectOff() throws FileSystemException {
        this.testResolveFolderSlash(connectionUri + "/read-tests", false);
    }

    @Test
    public void testResolveFolderSlashNoRedirectOn() throws FileSystemException {
        this.testResolveFolderSlash(connectionUri + "/read-tests", true);
    }

    @Test
    public void testResolveFolderSlashYesRedirectOff() throws FileSystemException {
        this.testResolveFolderSlash(connectionUri + "/read-tests/", false);
    }

    @Test
    public void testResolveFolderSlashYesRedirectOn() throws FileSystemException {
        this.testResolveFolderSlash(connectionUri + "/read-tests/", true);
    }

    @Test
    public void testResolveIPv6Url() throws FileSystemException {
        String ipv6Url = "http4://[fe80::1c42:dae:8370:aea6%en1]";
        Http4FileObject fileObject = (Http4FileObject)VFS.getManager().resolveFile("http4://[fe80::1c42:dae:8370:aea6%en1]", new FileSystemOptions());
        Http4ProviderTestCase.assertEquals((String)"http://[fe80::1c42:dae:8370:aea6%en1]/", (String)fileObject.getInternalURI().toString());
    }
}

