/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.junit;

import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.tags.junit.AssertTagSupport;

public class AssertEqualsTag
extends AssertTagSupport {
    private Expression actual;
    private Expression expected;

    public void doTag(XMLOutput output) throws JellyTagException {
        String message = this.getBodyText();
        Object expectedValue = this.expected.evaluate(((TagSupport)this).context);
        Object actualValue = this.actual.evaluate(((TagSupport)this).context);
        if (expectedValue == null && actualValue == null) {
            return;
        }
        if (actualValue != null && expectedValue.equals(actualValue)) {
            return;
        }
        String expressions = "\nExpected expression: " + this.expected.getExpressionText() + "\nActual expression: " + this.actual.getExpressionText();
        this.failNotEquals(message, expectedValue, actualValue, expressions);
    }

    public void setActual(Expression actual) {
        this.actual = actual;
    }

    public void setExpected(Expression expected) {
        this.expected = expected;
    }
}

