/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.gzip;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.compress.compressors.gzip.ExtraField;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class GzipParametersTest {
    GzipParametersTest() {
    }

    @Test
    void testDeflaterStrategy() {
        GzipParameters gzipParameters = new GzipParameters();
        Assertions.assertEquals((int)0, (int)gzipParameters.getDeflateStrategy());
        gzipParameters.setDeflateStrategy(2);
        Assertions.assertEquals((int)2, (int)gzipParameters.getDeflateStrategy());
    }

    @Test
    void testEquals() throws IOException {
        GzipParameters gzipParameters1 = new GzipParameters();
        GzipParameters gzipParameters2 = new GzipParameters();
        Assertions.assertEquals((Object)gzipParameters1, (Object)gzipParameters2);
        gzipParameters1.setExtraField(new ExtraField().addSubField("AA", "XXXX".getBytes(StandardCharsets.ISO_8859_1)));
        gzipParameters2.setExtraField(new ExtraField().addSubField("AA", "XXXX".getBytes(StandardCharsets.ISO_8859_1)));
        Assertions.assertEquals((Object)gzipParameters1, (Object)gzipParameters1);
        Assertions.assertEquals((Object)gzipParameters1, (Object)gzipParameters2);
        Assertions.assertEquals((Object)gzipParameters2, (Object)gzipParameters1);
        gzipParameters2.setExtraField(new ExtraField().addSubField("BB", "XXXX".getBytes(StandardCharsets.ISO_8859_1)));
        Assertions.assertNotEquals((Object)gzipParameters1, (Object)gzipParameters2);
    }

    @Test
    void testHashCode() throws IOException {
        GzipParameters gzipParameters1 = new GzipParameters();
        GzipParameters gzipParameters2 = new GzipParameters();
        Assertions.assertEquals((int)gzipParameters1.hashCode(), (int)gzipParameters2.hashCode());
        gzipParameters1.setExtraField(new ExtraField().addSubField("AA", "XXXX".getBytes(StandardCharsets.ISO_8859_1)));
        gzipParameters2.setExtraField(new ExtraField().addSubField("AA", "XXXX".getBytes(StandardCharsets.ISO_8859_1)));
        Assertions.assertEquals((int)gzipParameters1.hashCode(), (int)gzipParameters1.hashCode());
        Assertions.assertEquals((int)gzipParameters1.hashCode(), (int)gzipParameters2.hashCode());
        Assertions.assertEquals((int)gzipParameters2.hashCode(), (int)gzipParameters1.hashCode());
        gzipParameters2.setExtraField(new ExtraField().addSubField("BB", "XXXX".getBytes(StandardCharsets.ISO_8859_1)));
        Assertions.assertNotEquals((int)gzipParameters1.hashCode(), (int)gzipParameters2.hashCode());
    }

    @ParameterizedTest
    @CsvSource(value={"          , hello\u0000world, false", "ISO-8859-1, hello\u0000world, false", "UTF-8     , hello\u0000world, false", "UTF-16BE  , helloworld, false"})
    void testIllegalCommentOrFileName(Charset charset, String text) {
        GzipParameters gzipParameters = new GzipParameters();
        gzipParameters.setFileNameCharset(charset);
        Assertions.assertThrows(IllegalArgumentException.class, () -> gzipParameters.setComment(text));
        Assertions.assertNull((Object)gzipParameters.getComment());
        Assertions.assertThrows(IllegalArgumentException.class, () -> gzipParameters.setFilename(text));
        Assertions.assertNull((Object)gzipParameters.getFileName());
        Assertions.assertThrows(IllegalArgumentException.class, () -> gzipParameters.setFileName(text));
        Assertions.assertNull((Object)gzipParameters.getFileName());
        Assertions.assertEquals((Object)gzipParameters, (Object)gzipParameters);
    }

    @ParameterizedTest
    @CsvSource(value={"          , helloworld", "          , hello\u00e9world", "ISO-8859-1, helloworld", "ISO-8859-1, hello\u00e9world", "UTF-8     , helloworld", "UTF-8     , hello\u00e9world"})
    void testLegalCommentOrFileName(Charset charset, String text) {
        GzipParameters gzipParameters = new GzipParameters();
        gzipParameters.setFileNameCharset(charset);
        gzipParameters.setComment(text);
        Assertions.assertEquals((Object)text, (Object)gzipParameters.getComment());
        gzipParameters.setFilename(text);
        Assertions.assertEquals((Object)text, (Object)gzipParameters.getFileName());
        gzipParameters.setFileName(text);
        Assertions.assertEquals((Object)text, (Object)gzipParameters.getFileName());
        Assertions.assertEquals((Object)gzipParameters, (Object)gzipParameters);
    }

    @Test
    void testToString() {
        GzipParameters gzipParameters = new GzipParameters();
        Assertions.assertTrue((boolean)gzipParameters.toString().contains("UNKNOWN"));
        gzipParameters.setOS(GzipParameters.OS.Z_SYSTEM);
        Assertions.assertTrue((boolean)gzipParameters.toString().contains("Z_SYSTEM"));
        Assertions.assertEquals((Object)gzipParameters, (Object)gzipParameters);
    }
}

