/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.dump.DumpArchiveInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class DumpTest
extends AbstractTest {
    private void archiveDetection(File f) throws Exception {
        try (InputStream is = Files.newInputStream(f.toPath(), new OpenOption[0]);
             ArchiveInputStream archiveInputStream = ArchiveStreamFactory.DEFAULT.createArchiveInputStream((InputStream)new BufferedInputStream(is));){
            Assertions.assertEquals(DumpArchiveInputStream.class, archiveInputStream.getClass());
        }
    }

    private void checkDumpArchive(File f) throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("");
        expected.add("lost+found/");
        expected.add("test1.xml");
        expected.add("test2.xml");
        try (InputStream is = Files.newInputStream(f.toPath(), new OpenOption[0]);
             DumpArchiveInputStream inputStream = new DumpArchiveInputStream(is);){
            this.checkArchiveContent((ArchiveInputStream<?>)inputStream, (List<String>)expected);
        }
    }

    @Test
    void testArchiveDetection() throws Exception {
        this.archiveDetection(DumpTest.getFile("bla.dump"));
    }

    @Test
    void testCheckArchive() throws Exception {
        this.checkDumpArchive(DumpTest.getFile("bla.dump"));
    }

    @Test
    void testCheckCompressedArchive() throws Exception {
        this.checkDumpArchive(DumpTest.getFile("bla.z.dump"));
    }

    @Test
    void testCompressedArchiveDetection() throws Exception {
        this.archiveDetection(DumpTest.getFile("bla.z.dump"));
    }

    @Test
    void testCompressedDumpUnarchiveAll() throws Exception {
        this.unarchiveAll(DumpTest.getFile("bla.z.dump"));
    }

    @Test
    void testDumpUnarchiveAll() throws Exception {
        this.unarchiveAll(DumpTest.getFile("bla.dump"));
    }

    private void unarchiveAll(File input) throws Exception {
        try (InputStream is = Files.newInputStream(input.toPath(), new OpenOption[0]);
             ArchiveInputStream in = ArchiveStreamFactory.DEFAULT.createArchiveInputStream("dump", is);){
            in.forEach(entry -> {
                File archiveEntry = this.newTempFile(entry.getName());
                archiveEntry.getParentFile().mkdirs();
                if (entry.isDirectory()) {
                    archiveEntry.mkdir();
                } else {
                    Files.copy((InputStream)in, archiveEntry.toPath(), new CopyOption[0]);
                }
            });
        }
    }
}

