/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.bugs;

import org.apache.commons.beanutils2.BeanIntrospector;
import org.apache.commons.beanutils2.BeanUtilsBean;
import org.apache.commons.beanutils2.PropertyUtilsBean;
import org.apache.commons.beanutils2.SuppressPropertiesBeanIntrospector;
import org.apache.commons.beanutils2.TestEnum;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EnumDeclaringClassTest {
    @Test
    public void testAllowAccessToClassPropertyFromBeanUtilsBean() throws ReflectiveOperationException {
        BeanUtilsBean bub = new BeanUtilsBean();
        PropertyUtilsBean propertyUtilsBean = bub.getPropertyUtils();
        propertyUtilsBean.removeBeanIntrospector((BeanIntrospector)SuppressPropertiesBeanIntrospector.SUPPRESS_DECLARING_CLASS);
        Fixture fixture = new Fixture();
        String string = bub.getProperty((Object)fixture, "testEnum.declaringClass");
        Assertions.assertEquals((Object)TestEnum.class.getName(), (Object)string);
        Class teClass = (Class)Assertions.assertInstanceOf(Class.class, (Object)propertyUtilsBean.getNestedProperty((Object)fixture, "testEnum.declaringClass"));
        ClassLoader classLoader = teClass.getClassLoader();
        Assertions.assertNotNull((Object)classLoader);
        Assertions.assertNotNull((Object)bub.getProperty((Object)fixture, "testEnum.declaringClass.classLoader"));
        Assertions.assertInstanceOf(ClassLoader.class, (Object)propertyUtilsBean.getNestedProperty((Object)fixture, "testEnum.declaringClass.classLoader"));
    }

    @Test
    public void testAllowAccessToClassPropertyFromPropertyUtilsBean() throws ReflectiveOperationException {
        PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
        propertyUtilsBean.removeBeanIntrospector((BeanIntrospector)SuppressPropertiesBeanIntrospector.SUPPRESS_DECLARING_CLASS);
        Fixture fixture = new Fixture();
        Object cls = propertyUtilsBean.getNestedProperty((Object)fixture, "testEnum.declaringClass");
        Class teClass = (Class)Assertions.assertInstanceOf(Class.class, (Object)cls);
        ClassLoader classLoader = teClass.getClassLoader();
        Assertions.assertNotNull((Object)classLoader);
        Assertions.assertInstanceOf(ClassLoader.class, (Object)propertyUtilsBean.getNestedProperty((Object)fixture, "testEnum.declaringClass.classLoader"));
    }

    @Test
    public void testSuppressClassPropertyByDefaultFromBeanUtilsBean() throws ReflectiveOperationException {
        Fixture fixture = new Fixture();
        BeanUtilsBean bub = new BeanUtilsBean();
        Assertions.assertThrows(NoSuchMethodException.class, () -> bub.getProperty((Object)fixture, "testEnum.declaringClass.classLoader"));
        Assertions.assertThrows(NoSuchMethodException.class, () -> bub.getPropertyUtils().getNestedProperty((Object)fixture, "testEnum.declaringClass.classLoader"));
    }

    @Test
    public void testSuppressClassPropertyByDefaultFromPropertyUtilsBean() throws ReflectiveOperationException {
        Fixture fixture = new Fixture();
        PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
        Assertions.assertThrows(NoSuchMethodException.class, () -> propertyUtilsBean.getNestedProperty((Object)fixture, "testEnum.declaringClass.classLoader"));
    }

    public static class Fixture {
        String name = "default";
        TestEnum testEnum = TestEnum.A;

        public String getName() {
            return this.name;
        }

        public TestEnum getTestEnum() {
            return this.testEnum;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setTestEnum(TestEnum day) {
            this.testEnum = day;
        }
    }
}

