/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.pref;

import java.awt.Component;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.cayenne.modeler.dialog.pref.DataSourceCreatorView;
import org.apache.cayenne.modeler.dialog.pref.DataSourcePreferences;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.modeler.util.AdapterMapping;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.DbAdapterInfo;
import org.apache.cayenne.swing.BindingBuilder;

public class DataSourceCreator
extends CayenneController {
    private static final String NO_ADAPTER = "Custom / Undefined";
    protected DataSourceCreatorView view;
    protected boolean canceled;
    protected Map dataSources;

    public DataSourceCreator(DataSourcePreferences parent) {
        super(parent);
        this.view = new DataSourceCreatorView((JDialog)SwingUtilities.getWindowAncestor(parent.getView()));
        this.dataSources = parent.getDataSources();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(DbAdapterInfo.getStandardAdapters());
        model.insertElementAt(NO_ADAPTER, 0);
        this.view.getAdapters().setModel(model);
        this.view.getAdapters().setSelectedIndex(0);
        String suggestion = "DataSource0";
        for (int i = 1; i <= this.dataSources.size() && this.dataSources.containsKey(suggestion = "DataSource" + i); ++i) {
        }
        this.view.getDataSourceName().setText(suggestion);
        this.initBindings();
    }

    @Override
    public Component getView() {
        return this.view;
    }

    protected void initBindings() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getCancelButton(), "cancelAction()");
        builder.bindToAction(this.view.getOkButton(), "okAction()");
    }

    public void okAction() {
        if (this.getName() == null) {
            JOptionPane.showMessageDialog(this.view, "Enter DataSource Name", null, 2);
        } else if (this.dataSources.containsKey(this.getName())) {
            JOptionPane.showMessageDialog(this.view, "'" + this.getName() + "' is already in use, enter a different name", null, 2);
        } else {
            this.canceled = false;
            this.view.dispose();
        }
    }

    public void cancelAction() {
        this.canceled = true;
        this.view.dispose();
    }

    public DBConnectionInfo startupAction() {
        this.canceled = true;
        this.view.setModal(true);
        this.view.pack();
        this.view.setResizable(false);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
        return this.createDataSource();
    }

    public String getName() {
        String name = this.view.getDataSourceName().getText();
        return name.length() > 0 ? name : null;
    }

    protected DBConnectionInfo createDataSource() {
        if (this.canceled) {
            return null;
        }
        DBConnectionInfo dataSource = (DBConnectionInfo)this.getApplication().getCayenneProjectPreferences().getDetailObject(DBConnectionInfo.class).create(this.getName());
        Object adapter = this.view.getAdapters().getSelectedItem();
        if (NO_ADAPTER.equals(adapter)) {
            adapter = null;
        }
        if (adapter != null) {
            String adapterString = adapter.toString();
            dataSource.setDbAdapter(adapterString);
            AdapterMapping defaultMap = this.getApplication().getAdapterMapping();
            dataSource.setJdbcDriver(defaultMap.jdbcDriverForAdapter(adapterString));
            dataSource.setUrl(defaultMap.jdbcURLForAdapter(adapterString));
        }
        return dataSource;
    }
}

