/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action.dbimport;

import java.awt.event.ActionEvent;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.dbsync.reverse.dbimport.SchemaContainer;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.dbimport.TreeManipulationAction;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;

public class AddSchemaAction
extends TreeManipulationAction {
    private static final String ACTION_NAME = "Add Schema";
    private static final String ICON_NAME = "icon-dbi-schema.png";

    public AddSchemaAction(Application application) {
        super(ACTION_NAME, application);
        this.insertableNodeClass = Schema.class;
    }

    @Override
    public String getIconName() {
        return ICON_NAME;
    }

    @Override
    public void performAction(ActionEvent e) {
        ReverseEngineering reverseEngineeringOldCopy = this.prepareElements();
        Schema newSchema = new Schema(this.name);
        if (this.canBeInserted(this.selectedElement)) {
            ((SchemaContainer)this.selectedElement.getUserObject()).addSchema(newSchema);
            this.selectedElement.add(new DbImportTreeNode(newSchema));
            this.updateSelected = true;
        } else if (this.canInsert()) {
            if (this.parentElement.isReverseEngineering()) {
                ((ReverseEngineering)this.parentElement.getUserObject()).addSchema(newSchema);
            } else {
                ((Catalog)this.parentElement.getUserObject()).addSchema(newSchema);
            }
            this.parentElement.add(new DbImportTreeNode(newSchema));
            this.updateSelected = false;
        }
        this.completeInserting(reverseEngineeringOldCopy);
    }
}

