/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import java.io.File;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerController;
import org.apache.cayenne.modeler.action.NewProjectAction;
import org.apache.cayenne.modeler.action.OpenProjectAction;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.project.Project;

public class RevertAction
extends CayenneAction {
    public static String getActionName() {
        return "Revert";
    }

    public RevertAction(Application application) {
        super(RevertAction.getActionName(), application);
    }

    @Override
    public void performAction(ActionEvent e) {
        Project project = this.getCurrentProject();
        if (project == null) {
            return;
        }
        boolean isNew = project.getConfigurationResource() == null;
        CayenneModelerController controller = this.getApplication().getFrameController();
        controller.projectClosedAction();
        File fileDirectory = new File(project.getConfigurationResource().getURL().getPath());
        if (!isNew && fileDirectory.isFile()) {
            OpenProjectAction openAction = controller.getApplication().getActionManager().getAction(OpenProjectAction.class);
            openAction.openProject(fileDirectory);
        } else {
            if (!(project instanceof Project)) {
                throw new CayenneRuntimeException("Only ApplicationProjects are supported.", new Object[0]);
            }
            controller.getApplication().getActionManager().getAction(NewProjectAction.class).performAction(e);
        }
        this.application.getUndoManager().discardAllEdits();
    }
}

