/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token.model;

import java.util.ArrayList;
import org.apache.cayenne.dbsync.merge.context.MergerContext;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.model.AbstractToModelToken;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;

public class DropColumnToModel
extends AbstractToModelToken.EntityAndColumn {
    public DropColumnToModel(DbEntity entity, DbAttribute column) {
        super("Drop Column", 25, entity, column);
    }

    @Override
    public MergerToken createReverse(MergerTokenFactory factory) {
        return factory.createAddColumnToDb(this.getEntity(), this.getColumn());
    }

    @Override
    public void execute(MergerContext mergerContext) {
        ArrayList<DbRelationship> dbRelationships = new ArrayList<DbRelationship>(this.getEntity().getRelationships());
        for (DbRelationship dbRelationship : dbRelationships) {
            for (DbJoin join : dbRelationship.getJoins()) {
                if (join.getSource() != this.getColumn() && join.getTarget() != this.getColumn()) continue;
                DropColumnToModel.remove(mergerContext.getDelegate(), dbRelationship, true);
            }
        }
        for (ObjEntity objEntity : this.getEntity().mappedObjEntities()) {
            ObjAttribute objAttribute = objEntity.getAttributeForDbAttribute(this.getColumn());
            if (objAttribute == null) continue;
            objEntity.removeAttribute(objAttribute.getName());
            mergerContext.getDelegate().objAttributeRemoved(objAttribute);
        }
        this.getEntity().removeAttribute(this.getColumn().getName());
        mergerContext.getDelegate().dbAttributeRemoved(this.getColumn());
    }
}

