/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.factory;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dbsync.merge.factory.DefaultMergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.db.AddColumnToDb;
import org.apache.cayenne.dbsync.merge.token.db.SetAllowNullToDb;
import org.apache.cayenne.dbsync.merge.token.db.SetColumnTypeToDb;
import org.apache.cayenne.dbsync.merge.token.db.SetNotNullToDb;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;

public class OracleMergerTokenFactory
extends DefaultMergerTokenFactory {
    @Override
    public MergerToken createAddColumnToDb(final DbEntity entity, final DbAttribute column) {
        return new AddColumnToDb(entity, column){

            @Override
            protected void appendPrefix(StringBuffer sqlBuffer, QuotingStrategy context) {
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(context.quotedFullyQualifiedName(entity));
                sqlBuffer.append(" ADD ");
                sqlBuffer.append(context.quotedName(column));
                sqlBuffer.append(" ");
            }
        };
    }

    @Override
    public MergerToken createSetColumnTypeToDb(final DbEntity entity, DbAttribute columnOriginal, final DbAttribute columnNew) {
        return new SetColumnTypeToDb(entity, columnOriginal, columnNew){

            @Override
            protected void appendPrefix(StringBuffer sqlBuffer, QuotingStrategy context) {
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(context.quotedFullyQualifiedName(entity));
                sqlBuffer.append(" MODIFY ");
                sqlBuffer.append(context.quotedName(columnNew));
                sqlBuffer.append(" ");
            }
        };
    }

    @Override
    public MergerToken createSetAllowNullToDb(DbEntity entity, final DbAttribute column) {
        return new SetAllowNullToDb(entity, column){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                StringBuffer sqlBuffer = new StringBuffer();
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(adapter.getQuotingStrategy().quotedFullyQualifiedName(this.getEntity()));
                sqlBuffer.append(" MODIFY ");
                adapter.createTableAppendColumn(sqlBuffer, column);
                return Collections.singletonList(sqlBuffer.toString());
            }
        };
    }

    @Override
    public MergerToken createSetNotNullToDb(DbEntity entity, final DbAttribute column) {
        return new SetNotNullToDb(entity, column){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                StringBuffer sqlBuffer = new StringBuffer();
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(adapter.getQuotingStrategy().quotedFullyQualifiedName(this.getEntity()));
                sqlBuffer.append(" MODIFY ");
                adapter.createTableAppendColumn(sqlBuffer, column);
                return Collections.singletonList(sqlBuffer.toString());
            }
        };
    }
}

