/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush.operation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.access.flush.EffectiveOpId;
import org.apache.cayenne.access.flush.operation.DbRowOp;
import org.apache.cayenne.access.flush.operation.DbRowOpGraph;
import org.apache.cayenne.access.flush.operation.DbRowOpSorter;
import org.apache.cayenne.access.flush.operation.DbRowOpType;
import org.apache.cayenne.access.flush.operation.DbRowOpVisitor;
import org.apache.cayenne.access.flush.operation.DeleteDbRowOp;
import org.apache.cayenne.access.flush.operation.InsertDbRowOp;
import org.apache.cayenne.access.flush.operation.UpdateDbRowOp;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.util.SingleEntryMap;

public class GraphBasedDbRowOpSorter
implements DbRowOpSorter {
    private final DbRowOpTypeVisitor rowOpTypeVisitor = new DbRowOpTypeVisitor();
    private final Provider<DataDomain> dataDomainProvider;
    private volatile Map<DbEntity, List<DbRelationship>> relationships;

    public GraphBasedDbRowOpSorter(@Inject Provider<DataDomain> dataDomainProvider) {
        this.dataDomainProvider = dataDomainProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDataSync() {
        Map<DbEntity, List<DbRelationship>> localRelationships = this.relationships;
        if (localRelationships == null) {
            GraphBasedDbRowOpSorter graphBasedDbRowOpSorter = this;
            synchronized (graphBasedDbRowOpSorter) {
                localRelationships = this.relationships;
                if (localRelationships == null) {
                    this.initDataNoSync();
                }
            }
        }
    }

    private void initDataNoSync() {
        this.relationships = new HashMap<DbEntity, List<DbRelationship>>();
        EntityResolver resolver = ((DataDomain)this.dataDomainProvider.get()).getEntityResolver();
        resolver.getDbEntities().forEach(entity -> entity.getRelationships().forEach(dbRelationship -> {
            if (dbRelationship.isToMany() || !dbRelationship.isToPK() || dbRelationship.isToDependentPK()) {
                return;
            }
            this.relationships.computeIfAbsent((DbEntity)entity, e -> new ArrayList()).add(dbRelationship);
        }));
    }

    @Override
    public List<DbRowOp> sort(List<DbRowOp> dbRows) {
        this.initDataSync();
        HashMap indexById = new HashMap(dbRows.size());
        dbRows.forEach(op -> indexById.computeIfAbsent(this.effectiveIdFor((DbRowOp)op), id -> new ArrayList(1)).add(op));
        boolean hasMeaningfulIds = indexById.size() != dbRows.size();
        DbRowOpGraph graph = new DbRowOpGraph();
        dbRows.forEach(op -> {
            this.processRelationships(indexById, graph, (DbRowOp)op);
            if (hasMeaningfulIds) {
                this.processMeaningfulIds(indexById, graph, (DbRowOp)op);
            }
            graph.add((DbRowOp)op);
        });
        return graph.topSort();
    }

    private void processRelationships(Map<EffectiveOpId, List<DbRowOp>> indexByDbId, DbRowOpGraph graph, DbRowOp op) {
        DbRowOpType opType = op.accept(this.rowOpTypeVisitor);
        this.relationships.getOrDefault(op.getEntity(), Collections.emptyList()).forEach(relationship -> this.getParentsOpId(op, (DbRelationship)relationship).forEach((parentOpId, snapshot) -> indexByDbId.getOrDefault(parentOpId, Collections.emptyList()).forEach(parentOp -> {
            if (op == parentOp) {
                return;
            }
            DbRowOpType parentOpType = parentOp.accept(this.rowOpTypeVisitor);
            switch (opType) {
                case INSERT: {
                    if (parentOpType == DbRowOpType.DELETE) break;
                    graph.add(op, (DbRowOp)parentOp);
                    break;
                }
                case UPDATE: {
                    switch (parentOpType) {
                        case INSERT: {
                            graph.add(op, (DbRowOp)parentOp);
                            break;
                        }
                        case DELETE: {
                            graph.add((DbRowOp)parentOp, op);
                            break;
                        }
                        case UPDATE: {
                            Boolean fkReferenceUpdated = parentOp.accept(new FkUpdateChecker((DbRelationship)relationship));
                            if (fkReferenceUpdated != Boolean.TRUE) break;
                            graph.add((DbRowOp)parentOp, op);
                        }
                    }
                }
                case DELETE: {
                    if (parentOpType != DbRowOpType.DELETE) break;
                    graph.add((DbRowOp)parentOp, op);
                }
            }
        })));
    }

    private void processMeaningfulIds(Map<EffectiveOpId, List<DbRowOp>> indexById, DbRowOpGraph graph, DbRowOp op) {
        indexById.get(this.effectiveIdFor(op)).forEach(sameIdOp -> {
            if (op == sameIdOp) {
                return;
            }
            DbRowOpType sameIdOpType = sameIdOp.accept(this.rowOpTypeVisitor);
            if (sameIdOpType == DbRowOpType.DELETE) {
                graph.add(op, (DbRowOp)sameIdOp);
            }
        });
    }

    private Map<EffectiveOpId, Map<String, Object>> getParentsOpId(DbRowOp op, DbRelationship relationship) {
        List<Map<String, Object>> parentIdSnapshots = op.accept(new DbRowOpSnapshotVisitor(relationship));
        if (parentIdSnapshots.size() == 1) {
            EffectiveOpId id = this.effectiveIdFor(relationship, parentIdSnapshots.get(0));
            if (id != null) {
                return Collections.singletonMap(id, parentIdSnapshots.get(0));
            }
            return Collections.emptyMap();
        }
        HashMap<EffectiveOpId, Map<String, Object>> effectiveOpIds = new HashMap<EffectiveOpId, Map<String, Object>>(parentIdSnapshots.size());
        parentIdSnapshots.forEach(snapshot -> {
            EffectiveOpId id = this.effectiveIdFor(relationship, (Map<String, Object>)snapshot);
            if (id != null) {
                effectiveOpIds.put(id, (Map<String, Object>)snapshot);
            }
        });
        return effectiveOpIds;
    }

    private EffectiveOpId effectiveIdFor(DbRowOp op) {
        return new EffectiveOpId(op.getEntity().getName(), op.getChangeId());
    }

    private EffectiveOpId effectiveIdFor(DbRelationship relationship, Map<String, Object> opSnapshot) {
        int len = relationship.getJoins().size();
        Map<String, Object> idMap = len == 1 ? new SingleEntryMap(relationship.getJoins().get(0).getTargetName()) : new HashMap(len);
        relationship.getJoins().forEach(join -> {
            Object value = opSnapshot.get(join.getSourceName());
            if (value == null) {
                return;
            }
            idMap.put(join.getTargetName(), value);
        });
        if (idMap.size() != len) {
            return null;
        }
        return new EffectiveOpId(relationship.getTargetEntityName(), idMap);
    }

    private static class DbRowOpTypeVisitor
    implements DbRowOpVisitor<DbRowOpType> {
        private DbRowOpTypeVisitor() {
        }

        @Override
        public DbRowOpType visitDelete(DeleteDbRowOp dbRow) {
            return DbRowOpType.DELETE;
        }

        @Override
        public DbRowOpType visitInsert(InsertDbRowOp dbRow) {
            return DbRowOpType.INSERT;
        }

        @Override
        public DbRowOpType visitUpdate(UpdateDbRowOp dbRow) {
            return DbRowOpType.UPDATE;
        }
    }

    private static class DbRowOpSnapshotVisitor
    implements DbRowOpVisitor<List<Map<String, Object>>> {
        private final DbRelationship relationship;

        private DbRowOpSnapshotVisitor(DbRelationship relationship) {
            this.relationship = relationship;
        }

        @Override
        public List<Map<String, Object>> visitInsert(InsertDbRowOp dbRow) {
            return Collections.singletonList(dbRow.getValues().getSnapshot());
        }

        @Override
        public List<Map<String, Object>> visitUpdate(UpdateDbRowOp dbRow) {
            Map<String, Object> updatedSnapshot = dbRow.getValues().getSnapshot();
            if (dbRow.getChangeId().getEntityName().startsWith("db:")) {
                return Collections.singletonList(updatedSnapshot);
            }
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(2);
            result.add(updatedSnapshot);
            Map<String, Object> cachedSnapshot = this.getCachedSnapshot(dbRow.getObject());
            cachedSnapshot.entrySet().forEach(entry -> {
                if (!updatedSnapshot.containsKey(entry.getKey())) {
                    entry.setValue(null);
                }
            });
            result.add(cachedSnapshot);
            return result;
        }

        @Override
        public List<Map<String, Object>> visitDelete(DeleteDbRowOp dbRow) {
            Map<String, Object> cachedSnapshot = this.getCachedSnapshot(dbRow.getObject());
            return Collections.singletonList(cachedSnapshot);
        }

        private Map<String, Object> getCachedSnapshot(Persistent object) {
            ObjectIdQuery query = new ObjectIdQuery(object.getObjectId(), true, 1);
            QueryResponse response = object.getObjectContext().getChannel().onQuery(null, query);
            List result = response.firstList();
            if (result == null || result.size() == 0) {
                return Collections.emptyMap();
            }
            DataRow dataRow = (DataRow)result.get(0);
            int joinSize = this.relationship.getJoins().size();
            SingleEntryMap<String, Object> snapshot = joinSize == 1 ? new SingleEntryMap(this.relationship.getJoins().get(0).getSourceName()) : new HashMap(joinSize);
            this.relationship.getJoins().forEach(join -> {
                Object value = dataRow.get(join.getSourceName());
                if (value != null) {
                    snapshot.put(join.getSourceName(), value);
                }
            });
            GraphManager graphManager = object.getObjectContext().getGraphManager();
            if (graphManager instanceof ObjectStore) {
                ObjectStore store = (ObjectStore)graphManager;
                store.getFlattenedIds(object.getObjectId()).forEach(flattenedId -> {
                    Map<String, Object> idSnapshot = flattenedId.getIdSnapshot();
                    this.relationship.getJoins().forEach(join -> {
                        Object value = idSnapshot.get(join.getTargetName());
                        if (value != null) {
                            snapshot.put(join.getSourceName(), value);
                        }
                    });
                });
            }
            return snapshot;
        }
    }

    private static class FkUpdateChecker
    implements DbRowOpVisitor<Boolean> {
        private final DbRelationship relationship;

        public FkUpdateChecker(DbRelationship relationship) {
            this.relationship = relationship;
        }

        @Override
        public Boolean visitUpdate(UpdateDbRowOp dbRow) {
            for (DbJoin join : this.relationship.getJoins()) {
                for (DbAttribute attribute : dbRow.getValues().getUpdatedAttributes()) {
                    if (!attribute.getName().equals(join.getTargetName())) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

